package cn.qg.qaplatform.zdata.controller;

import cn.qg.qaplatform.common.JsonResult;
import cn.qg.qaplatform.zdata.domain.GenVccUser;
import cn.qg.qaplatform.zdata.service.VccDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@CrossOrigin
@RestController
@RequestMapping("vcc")
@Api(tags = "vcc造数据")
public class GenVccController {

    @Autowired
    VccDataService vccDataService;

    @PostMapping("/gen")
    @ApiOperation(value = "vcc造数据")
    public JsonResult genVccUser(@RequestParam(value = "namespace") String namespace,
                                 @RequestParam(value = "phoneNo") String phoneNo,
                                 @RequestParam(value = "channel") String channel,
                                 @RequestParam(value = "status") Integer status) throws Exception {
        if (status !=1 && status !=2 && status !=3 && status !=4) {
            return JsonResult.clientFailed("状态值必须是1、2、3、4中的一个！");
        }
        if (!channel.equals("214") && !channel.equals("217")) {
            return JsonResult.clientFailed("渠道必须为214或217");
        }
        GenVccUser result = vccDataService.makeVccUser(namespace, phoneNo, channel, status);
        if (result == null) {
            return JsonResult.serverFailed();
        }
        return JsonResult.success(result);
    }
}
