package cn.qg.qaplatform.zdata.service;

import cn.qg.qaplatform.zdata.domain.ApplyDataVo;
import cn.qg.qaplatform.zdata.domain.GenLoanUser;

import java.io.IOException;

public interface XyqbDataService {

    /**
     * 分配资金方
     */
    boolean assignFundCorp(String namespace, Integer fundId, String symbol) throws IOException;

    /**
     * 授信
     * @param applyDataVo 造数据的相关信息
     * @return 成功或失败
     */
    boolean quotaAuth(ApplyDataVo applyDataVo, boolean auditResult) throws Exception;

    /**
     * 提现
     * @param applyDataVo 造数据相关信息
     * @return 成功或失败
     */
    boolean withDraw(ApplyDataVo applyDataVo, boolean auditResult) throws Exception;

    /**
     * 放款
     * @param applyDataVo
     * @return
     */
    boolean makeLoan(ApplyDataVo applyDataVo, boolean payStatus) throws Exception;

    /**
     * 造数据
     * @param applyDataVo
     * @return
     * @throws Exception
     */
    boolean genLoanUser(ApplyDataVo applyDataVo) throws Exception;

    /**
     * 获取用户状态
     * @param namespace
     * @param phoneNo
     * @return
     */
    GenLoanUser queryUserStatus(String namespace, String phoneNo);

}
