package cn.quantgroup.qaplatform.common;

import cn.quantgroup.qaplatform.common.enums.Namespace;
import cn.quantgroup.qaplatform.config.DynamicDataSource;
import com.alibaba.druid.pool.DruidDataSource;


/**
 * 切换数据源
 * @author libo
 */
public class SwitchDataSource {

    public static final String SUFFIX = "?characterEncoding=utf-8&useSSL=false&serverTimezone=UTC&useAffectedRows=true";

    public static void dataSourceSwitch(String namespace, String database) {

        /**
         * PRE 环境
         */
        if (namespace.equals("pre")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.PRE.getUrl() + database + SUFFIX;
            String dbKey = Namespace.PRE.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.PRE.getUsername());
            druidDataSource.setPassword(Namespace.PRE.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * qa 环境
         */
        if (namespace.equals("qa")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.QA.getUrl() + database + SUFFIX;
            String dbKey = Namespace.QA.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.QA.getUsername());
            druidDataSource.setPassword(Namespace.QA.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * qa2 环境
         */
        if (namespace.equals("qa2")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.QA2.getUrl() + database + SUFFIX;
            String dbKey = Namespace.QA2.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.QA2.getUsername());
            druidDataSource.setPassword(Namespace.QA2.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * qa3 环境
         */
        if (namespace.equals("qa3")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.QA3.getUrl() + database + SUFFIX;
            String dbKey = Namespace.QA3.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.QA3.getUsername());
            druidDataSource.setPassword(Namespace.QA3.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * test1 环境
         */
        if (namespace.equals("test1")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.TEST1.getUrl() + database + SUFFIX;
            String dbKey = Namespace.TEST1.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.TEST1.getUsername());
            druidDataSource.setPassword(Namespace.TEST1.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * xjfq 环境
         */
        if (namespace.equals("xjfq")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.XJFQ.getUrl() + database + SUFFIX;
            String dbKey = Namespace.XJFQ.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.XJFQ.getUsername());
            druidDataSource.setPassword(Namespace.XJFQ.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * xyqb 环境
         */
        if (namespace.equals("xyqb")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.XYQB.getUrl() + database + SUFFIX;
            String dbKey = Namespace.XYQB.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.XYQB.getUsername());
            druidDataSource.setPassword(Namespace.XYQB.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }

        /**
         * fe 环境
         */
        if (namespace.equals("fe")) {
            DruidDataSource druidDataSource = new DruidDataSource();
            String url = Namespace.FE.getUrl() + database + SUFFIX;
            String dbKey = Namespace.FE.getKey();
            druidDataSource.setUrl(url);
            druidDataSource.setUsername(Namespace.FE.getUsername());
            druidDataSource.setPassword(Namespace.FE.getPassword());
            DynamicDataSource.dataSourcesMap.put(dbKey, druidDataSource);
            DynamicDataSource.setDataSource(dbKey);
        }
    }
}
