package cn.qg.qaplatform.controller;

import cn.qg.qaplatform.common.JsonResult;
import cn.qg.qaplatform.common.enums.VccStatusEnum;
import cn.qg.qaplatform.domain.QueryVccUser;
import cn.qg.qaplatform.service.VccDataService;
import cn.qg.qaplatform.utils.page.PageResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/vcc")
public class QueryVccController {

    @Autowired
    VccDataService vccDataService;

    @GetMapping("/getData")
    public JsonResult getVccData(@RequestParam(value = "namespace") String namespace,
                                 @RequestParam(value = "status") Integer status,
                                 @RequestParam(defaultValue = "1") Integer pageNum,
                                 @RequestParam(defaultValue = "10") Integer pageSize) {
        PageResult vccData = vccDataService.getVccData(namespace, status, pageNum, pageSize);
        return JsonResult.success(vccData);
    }

    @GetMapping("/getStatus")
    public JsonResult getUserStatus(String namespace, String phoneNo) {
        QueryVccUser queryVccUser = vccDataService.queryUserVccStatus(namespace, phoneNo);
        return JsonResult.success(queryVccUser);
    }

    @GetMapping("/checkData")
    public JsonResult checkUserData(String namespace, String phoneNo, String idCardNo) {
        QueryVccUser queryVccUser = vccDataService.queryUserVccStatus(namespace, phoneNo);
        if (queryVccUser == null) {
            return JsonResult.serverFailed("数据不存在！");
        }
        Map<String, Object> map = new HashMap<>();
        map.put("phoneNo", queryVccUser.getPhoneNo());
        map.put("userId", queryVccUser.getUserId());
        map.put("uuid", queryVccUser.getUuid());
        map.put("registeredFrom", queryVccUser.getRegisteredFrom());
        map.put("nextApplyTime", queryVccUser.getNextApplyTime());
        map.put("createdAt", queryVccUser.getCreatedAt());
        map.put("status", VccStatusEnum.getDescByCode(queryVccUser.getStatus()));
        return JsonResult.success(map);
    }
}
