package cn.quantgroup.qaplatform.test;

import cn.quantgroup.qaplatform.utils.DBUtils;
import cn.quantgroup.qaplatform.utils.EncryptUtils;
import cn.quantgroup.qaplatform.utils.HttpClientUtils;
import cn.quantgroup.qaplatform.utils.JsonTransUtils;
import com.alibaba.fastjson.JSONObject;

import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ProcessTest {
    public static String namespace = "test1";
    public static String phone = "13712345678";
    public static String token = "";
    public static String uuid = "";
    public static Long userId;
    public static int productId = 1;
    public static String name = "刘志国";
    public static String idNo = "455129197108031107";
    public static Long createdFrom = 1L;

    /**
     * 标准登录
     *
     * @throws Exception
     */
    public static void login() throws Exception {
        String url = "http://passportapi-" + namespace + ".liangkebang.net" + "/user/login/fastV1";
        Map<String, Object> params = new HashMap<>();
        params.put("channelId", "1");
        params.put("createdFrom", "1");
        params.put("key", "xyqb");
        params.put("btRegisterChannelId", "");
        params.put("dimension", "");
        params.put("click_id", "");
        Map<String, Object> header = new HashMap<String, Object>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String verification = EncryptUtils.base64Encrypt(phone);
        header.put("Authorization", verification);
        JSONObject result = HttpClientUtils.doPost(url, params, header);
        Map map = (Map) result.get("data");
        token = (String) map.get("token");
        System.out.println("登录: " + result);
    }

    /**
     * 查询用户中心id
     *
     * @throws SQLException
     */
    public static void checkUserId() throws SQLException {
        String sql = "select id, uuid from user where phone_no=" + phone;
        DBUtils dbUtils = new DBUtils(namespace, "xyqb_user", "qa", "qatest");
        dbUtils.connect();
        Map result = dbUtils.queryForMap(sql);
        uuid = (String) result.get("uuid");
        userId = (Long) result.get("id");
        System.out.println("查询用户中心id: " + result);
        dbUtils.closeConnection();
    }

    /**
     * 同步session到xyqb
     *
     * @throws URISyntaxException
     */
    public static void syncSessionToXyqb() throws URISyntaxException {
        String url = "http://api-" + namespace + ".liangkebang.net" + "/ex/login/receive_token?token=" + token;
        HttpClientUtils.doGetWithoutResponse(url);
    }

    /**
     * 授信session同步
     *
     * @throws URISyntaxException
     */
    public static void creditSessionSync() throws URISyntaxException {
        String url = "http://api-" + namespace + ".liangkebang.net" + "/v3/credit/apply?productId=" + productId;
        Map<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-auth-token", token);
        JSONObject result = HttpClientUtils.doGet(url, null, headers);
        System.out.println("授信session同步");
        System.out.println(result);
        if (!result.get("code").equals("0000")) {
            System.out.println("授信session同步失败");
        }
    }

    /**
     * 实名认证
     */
    public static void realNameVerified() {
        String url = "http://api-" + namespace + ".liangkebang.net" + "/loan/auth/id_no";
        Map<String, Object> params = new HashMap<>();
        params.put("name", name);
        params.put("idNo", idNo);
        params.put("idType", 0);
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", token);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("实名认证：" + result);
    }

    /**
     * 基本信息认证
     */
    public static void authBasicInfo() {
        String url = "http://scapi-" + namespace + ".liangkebang.net" + "/auth/basic2/infos";
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", token);
        Map<String, Object> params = new HashMap<>();
        params.put("firstName", "任明星");
        params.put("firstMobile", "13500000002");
        params.put("firstRelation", 2);
        params.put("secondName", "陈玉秋");
        params.put("secondMobile", "13500000001");
        params.put("secondRelation", 2);
        params.put("address", "中国电子大厦");
        params.put("city", "市辖区");
        params.put("cityCode", 110100);
        params.put("province", "北京市");
        params.put("provinceCode", 110000);
        params.put("districtCode", 110116);
        params.put("vocation", 3);
        params.put("salary", 3);
        params.put("education", 3);
        params.put("email", "12345678@qq.com");
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("基本信息认证：" + result);
    }

    /**
     * 进入上传身份证页
     */
    public static void enterAuthOcr() {
        String url = "http://mapi-" + namespace + ".liangkebang.net" + "/sc/auth/ocr/url";
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", token);
        Map<String, Object> params = new HashMap<>();
        String returnUrl = "http://scapi-" + namespace + ".liangkebang.net/auth-page";
        params.put("returnUrl", returnUrl);
        params.put("registerFrom", createdFrom);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        Map respData = (Map) result.get("data");
        String respUrl = (String) respData.get("url");
        String[] split1 = respUrl.split("\\?");
        String[] split2 = split1[1].split("\\&");
        String[] split3 = split2[0].split("\\=");
        String ockToken = split3[1];
        System.out.println("进入上传身份证页：" + result);
        System.out.println("OCR_token为：" + ockToken);

    }

    public static void main(String[] args) throws Exception {
        login();
        checkUserId();
        creditSessionSync();
        syncSessionToXyqb();
        realNameVerified();
        authBasicInfo();
        enterAuthOcr();
    }
}
