package cn.qg.qaplatform.controller;

import cn.qg.qaplatform.common.JsonResult;
import cn.qg.qaplatform.domain.GenVccUser;
import cn.qg.qaplatform.service.VccDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("vcc")
@Api(tags = "vcc造数据")
public class GenVccController {

    @Autowired
    VccDataService vccDataService;

    @PostMapping("/gen")
    @ApiOperation(value = "vcc造数据")
    public JsonResult genVccUser(String namespace, String phoneNo, String channel, Integer status) throws Exception {
        if (!channel.equals("214") && !channel.equals("217")) {
            return JsonResult.clientFailed("渠道必须为214或217");
        }
        GenVccUser result = vccDataService.makeVccUser(namespace, phoneNo, channel, status);
        return JsonResult.success(result);
    }
}
