package cn.qg.qaplatform.zdata.service.xyqb;

import cn.qg.qaplatform.zdata.entity.XjfqGenProcessVo;
import cn.qg.qaplatform.zdata.entity.XjfqUserEntity;

import java.util.List;
import java.util.Map;

/**
 * 单个状态数据查询
 */
public interface XyqbBasicQueryService {
    /**
     * 获取所有的用户状态
     */
    List<Map<String, Object>> getAllUserLoanStatus();

    /**
     * 获取所有环境信息
     */
    List<Map<String, Object>> getAllEnvInfo();

    /**
     * 根据uuid获取用户信息
     */
    List<XjfqUserEntity> getUserDataListByUuidList(String namespace, List<String> uuidList);

    /**
     * 获取未申请用户
     * @return uuidList
     */
    List<String> getUnApplyUserUuidList(String namespace, Integer channel);

    /**
     * 判断用户是否存在
     */
    boolean queryIfPhoneExist(String namespace, String phone);

    /**
     * 获取审核状态的用户Id列表
     */
    List<String> getAuditStatusUserIdList(String namespace, Integer status, Integer channel);

    /**
     * 审核通过未提现
     */
    List<String> queryAuthAndUnWithdraw(String namespace, Integer channel, Integer fundId);

    /**
     * 根据userIdList获取用户信息列表
     */
    List<XjfqUserEntity> getUserDataListByUserIdList(String namespace, List<String> userIdList);

    /**
     * 获取不同放款状态的用户
     */
    List<String> getLoanStatusUserIdList(String namespace, Integer status, Integer channel, Integer fundId);

    /**
     * 获取多订单用户信息列表
     */
    List<String> getMultiOrderUserDataList(String namespace);

    /**
     * 根据userId获取资金方id
     */
    Integer getAssignFundIdByUserId(String namespace, String userId);

    /**
     * 根据手机号查询用户信息
     */
    XjfqGenProcessVo getUserInfoByPhoneNo(String namespace, String phoneNo);

    /**
     * 根据userId获取用户放款状态
     */
    Integer getLoanProgressByUserId(String namespace, String userId);
}
