package cn.qg.qaplatform.mock.config;

import cn.qg.qaplatform.mock.interceptor.PayInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;


@Configuration
public class InterceptorConfig implements WebMvcConfigurer {

    @Bean
    public PayInterceptor payInterceptor() {
        return new PayInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(payInterceptor()).addPathPatterns("/mock/tzt-api/**", "/mock/balance-board/**");
    }

}
