package cn.qg.qaplatform.common.enums;

/**
 * 借款状态枚举
 */
public enum LoanStatus {

    UNAPPLY(0, "注册未申请"),
    UNDER_REVIEW(1, "授信中"),
    REVIEW_PASS(2, "审核通过"),
    REVIEW_REFUSE(3, "审核拒绝"),
    LOAN_ING(4, "审核通过未提现"),
    LOAN_SUCESS(5, "放款成功"),
    LOAN_FAIL(6, "放款失败"),
    MULTI_ORDER(7, "多订单白名单");

    private Integer status;
    private String desc;

    LoanStatus(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }
}
