package cn.qg.qaplatform.entity.xyqb;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

@Data
@TableName(value = "assign_funding_record")
public class AssignFundingRecord {

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 资产订单表ID
     */
    private Long assetOrderId;

    /**
     * 业务类型
     */
    private Integer businessType;

    /**
     * 分配状态 0未分配 1分配队列中 2分配中 3分配成功 4分配失败 5取消借款
     */
    private Integer assignStatus;

    /**
     * 资金方ID
     */
    private Long fundingCorpId;

    /**
     * 被拒绝的资金方列表,以","分隔
     */
    private String fundingBlockList;

    /**
     * 备注
     */
    private String remark;

    private Date createdAt;

    private Date updatedAt;

    /**
     * 尝试分配的次数
     */
    private Integer tryAssignCount;
}
