package cn.qg.qaplatform.stools.utils;

import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.model.*;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.*;

/**
 * 操作Jenkins的api
 */
public class JenkinsApi {
    // Jenkins 对象
    private JenkinsServer jenkinsServer;
    // http 客户端对象
    // private JenkinsHttpClient jenkinsHttpClient;

    // 连接 Jenkins 需要设置的信息
    static final String JENKINS_URL = "http://172.29.1.15:8080/";
    static final String JENKINS_USERNAME = "qahome";
    static final String JENKINS_PASSWORD = "Quantgroup123";

    /**
     * 构造方法中调用连接 Jenkins 方法
     */
    public JenkinsApi() {
        // 连接 Jenkins
        try {
            jenkinsServer = new JenkinsServer(new URI(JENKINS_URL), JENKINS_USERNAME, JENKINS_PASSWORD);
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        // 设置客户端连接 Jenkins
//        try {
//            jenkinsHttpClient = new JenkinsHttpClient(new URI(JENKINS_URL), JENKINS_USERNAME, JENKINS_PASSWORD);
//        } catch (URISyntaxException e) {
//            e.printStackTrace();
//        }
    }

    /**
     * 根据job名称获取job信息
     */
    public JobWithDetails getJobInfoByName(String jobName) {
        try {
            JobWithDetails job = jenkinsServer.getJob(jobName);
            return job;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取job列表
     * @return
     */
    public List<Map<String, String>> getJobList() {
        try {
            Map<String, Job> jobs = jenkinsServer.getJobs();
            List<Map<String, String>> jobList = new ArrayList<>();
            for (Job job:jobs.values()){
                Map<String, String> map = new HashMap<>();
                map.put("value", job.getName());
                map.put("label", job.getName());
                jobList.add(map);
            }
            return jobList;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取Job Build列表
     */
    public List<Build> getJobBuildList(String jobName, Integer num) {
        try {
            // 获取 Job 信息
            JobWithDetails job = jenkinsServer.getJob(jobName);
            // 获取全部 Build 信息
            Build lastBuild = job.getLastBuild();
            int lastBuildNumber = lastBuild.getNumber();
            List<Build> buildList = new ArrayList<>();
            for (int i = lastBuildNumber; i > lastBuildNumber - num; i--) {
                Build tempBuild = job.getBuildByNumber(i);
                if (tempBuild == null) {
                    return buildList;
                } else {
                    buildList.add(job.getBuildByNumber(i));
                }
            }
            return buildList;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 根据参数获取对应的build
     */
    public List<Build> getJobBuildList(String jobName, Integer num, String project) {
        try {
            // 获取 Job 信息
            JobWithDetails job = jenkinsServer.getJob(jobName);
            int lastBuildNumber = job.getLastBuild().getNumber();
            List<Build> buildList = new ArrayList<>();
            int caculator = 0;
            while (buildList.size() != num) {
                Build build = job.getBuildByNumber(lastBuildNumber - caculator);
                if (build == null) {
                    return buildList;
                }
                if (build.details().getParameters().get("GIT_REPO").equals(project)) {
                    buildList.add(build);
                }
                caculator += 1;
            }
            return buildList;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        JenkinsApi jenkinsApi = new JenkinsApi();
        List<Build> buildList = jenkinsApi.getJobBuildList("tke-java", 1, "kdsp");
        List<String> userList = new ArrayList<>();
        for (Build build: buildList) {
            System.out.println(build.details().getParameters().get("BRANCH_NAME"));
            System.out.println(build.details().getParameters().get("NAMESPACE"));
            System.out.println(build.details().getCauses().get(0).getUserName());
            userList.add(build.details().getCauses().get(0).getUserName());
            BuildResult buildResult = build.details().getResult();
            System.out.println(buildResult);
        }
        System.out.println(userList.size());
    }
}
