package cn.qg.qaplatform.zdata.controller.xyqb;

import cn.qg.qaplatform.zdata.service.xyqb.XyqbQueryService;
import cn.qg.qaplatform.utils.JsonResult;
import cn.qg.qaplatform.zdata.service.xyqb.XyqbBasicQueryService;
import cn.qg.qaplatform.utils.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/xyqb/query")
@Api(tags = "捞数据相关接口")
public class XyqbQueryController {

    @Autowired
    private XyqbBasicQueryService basicLoanStatusDataService;

    @Autowired
    private XyqbQueryService loanUserDataService;

    /**
     * @return 获取所有借款用户状态
     */
    @ApiOperation(value = "获取所有借款状态")
    @GetMapping("/getAllStatus")
    public JsonResult getLoanUserDataStatus() {
        List<Map<String, Object>> statusList = basicLoanStatusDataService.getAllUserLoanStatus();
        return JsonResult.success(statusList);
    }

    /**
     * @return 获取所有环境namespace
     */
    @ApiOperation(value = "获取所有环境信息")
    @GetMapping("/getAllEnv")
    public JsonResult getAllEnvInfo() {
        List<Map<String, Object>> envList = basicLoanStatusDataService.getAllEnvInfo();
        return JsonResult.success(envList);
    }

    /**
     * @param status 用户状态
     * @param pageNum 页码
     * @param pageSize 每页数量
     * @return 所有借款用户数据
     */
    @ApiOperation(value = "捞数据接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "namespace", value="环境，qa、qa2等", required = true),
            @ApiImplicitParam(name = "status", value = "借款状态", required = true),
            @ApiImplicitParam(name = "channel", value = "渠道id"),
            @ApiImplicitParam(name = "fundId", value = "资方id"),
            @ApiImplicitParam(name = "pageNum", value = "页码", defaultValue = "1"),
            @ApiImplicitParam(name = "pageSize", value = "每页数量", defaultValue = "10")
    })
    @GetMapping("/loanUser")
    public JsonResult getLoanUserData(@RequestParam(value = "namespace") String namespace,
                                      @RequestParam(value = "status") Integer status,
                                      @RequestParam(value = "channel" ) Integer channel,
                                      @RequestParam(value = "fundId") Integer fundId,
                                      @RequestParam(defaultValue = "1") Integer pageNum,
                                      @RequestParam(defaultValue = "10") Integer pageSize) {
        PageResult result = loanUserDataService.getLoanUserData(namespace, status, channel, fundId, pageNum, pageSize);
        return JsonResult.success(result);
    }

    /**
     * 查看手机号是否存在
     * @param phone
     * @return
     */
    @ApiOperation(value = "查询手机号是否存在于环境中")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "namespace", value = "环境"),
            @ApiImplicitParam(name = "phone", value = "手机号")
    })
    @GetMapping("/phoneExistence")
    public JsonResult checkPhoneExistence(@RequestParam(value = "namespace") String namespace,
                                          @RequestParam(value = "phone") String phone) {
        return JsonResult.success(basicLoanStatusDataService.queryIfPhoneExist(namespace, phone));
    }

    /**
     * todo
     * @param namespace
     * @param phoneNo
     * @return
     */
    @GetMapping("/getUserInfoByPhoneNo")
    public JsonResult getUserInfoByPhoneNo(@RequestParam(value = "namespace") String namespace,
                                           @RequestParam(value = "phoneNo") String phoneNo) {
        return null;
    }
}
