package cn.qg.qaplatform.test;

import cn.qg.qaplatform.utils.DBUtils;
import cn.qg.qaplatform.utils.EncryptUtils;
import cn.qg.qaplatform.utils.HttpClientUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class xyqb {
    public static String namespace = "xyqb";
    public static Integer channelId = 1;
    public static Integer fundId = 1040;
    public static String phone = "18300120382";
    public static String token = "";
    public static String uuid = "";
    public static Long userId;
    public static String productId = "1";
    public static String name = "刘志国";
    public static String idNo = "455129197108031107";
    public static Long createdFrom = 1L;
    public static String ocrToken;
    public static String idCardNo = "6222800007700762652";
    public static String orderNo = "";
    public static Integer bizType = 0;
    public static String auditResult = "true";
    public static String creditAmount = "10000";
    public static Integer maxAmount = 8000;
    public static Integer minAmount = 5000;
    public static Integer term = 3;
    public static Long accountId;
    public static String payToken = "";
    public static String cardNo = "6222800005354563814";
    public static Integer cardId;
    public static Integer cardBindInfoId;
    public static Integer loanId;
    public static String opToken;
    public static Integer money;
    public static Integer assignPeopleNum;
    public static String fundOpToken;

    /**
     * 标准登录
     *
     * @throws Exception
     */
    public static void login() throws Exception {
        String url = "http://passportapi-" + namespace + ".liangkebang.net" + "/user/login/fastV1";
        Map<String, Object> params = new HashMap<>();
        params.put("channelId", channelId);
        params.put("createdFrom", createdFrom);
        params.put("key", "xyqb");
        params.put("btRegisterChannelId", "");
        params.put("dimension", "");
        params.put("click_id", "");
        Map<String, Object> header = new HashMap<String, Object>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String verification = EncryptUtils.base64Encrypt(phone);
        header.put("Authorization", verification);
        JSONObject result = HttpClientUtils.doPost(url, params, header);
        Map map = (Map) result.get("data");
        token = map.get("token").toString();
        System.out.println("登录: " + result);

    }

    /**
     * 查询用户中心id
     *
     * @throws SQLException
     */
    public static void checkUserId() throws SQLException {
        String sql = "select id, uuid from user where phone_no=" + phone;
        DBUtils dbUtils = new DBUtils(namespace, "xyqb_user", "qa", "qatest");
        Map result = dbUtils.queryForMap(sql);
        uuid = result.get("uuid").toString();
        userId = (Long) result.get("id");
        System.out.println("查询用户中心id: " + result);
    }

    /**
     * 同步session到xyqb
     *
     * @throws URISyntaxException
     */
    public static void syncSessionToXyqb() throws URISyntaxException {
        String url = "http://api-" + namespace + ".liangkebang.net" + "/ex/login/receive_token?token=" + token;
        Map<String, Object> headers = new HashMap<String, Object>();
        headers.put("Content-Type", "application/json");
        HttpClientUtils.doGetReturnHtml(url, null, headers);
    }

    /**
     * 授信session同步
     *
     * @throws URISyntaxException
     */
    public static void creditSessionSync() throws URISyntaxException {
        String url = "http://api-" + namespace + ".liangkebang.net" + "/v3/credit/apply?productId=" + productId;
        Map<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-auth-token", token);
        JSONObject result = HttpClientUtils.doGetReturnJson(url, null, headers);
        System.out.println("授信session同步");
        System.out.println(result);
        if (!result.get("code").equals("0000")) {
            System.out.println("授信session同步失败");
        }
    }

    /**
     * 实名认证
     */
    public static void realNameVerified() {
        String url = "http://api-" + namespace + ".liangkebang.net" + "/loan/auth/id_no";
        Map<String, Object> params = new HashMap<>();
        params.put("name", name);
        params.put("idNo", idNo);
        params.put("idType", 0);
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", token);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("实名认证：" + result);
    }

    /**
     * 基本信息认证
     */
    public static void authBasicInfo() {
        String url = "http://scapi-" + namespace + ".liangkebang.net" + "/auth/basic2/infos";
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", token);
        Map<String, Object> params = new HashMap<>();
        params.put("firstName", "任明星");
        params.put("firstMobile", "13500000002");
        params.put("firstRelation", 2);
        params.put("secondName", "陈玉秋");
        params.put("secondMobile", "13500000001");
        params.put("secondRelation", 2);
        params.put("address", "中国电子大厦");
        params.put("city", "市辖区");
        params.put("cityCode", 110100);
        params.put("province", "北京市");
        params.put("provinceCode", 110000);
        params.put("districtCode", 110116);
        params.put("vocation", 3);
        params.put("salary", 3);
        params.put("education", 3);
        params.put("email", "12345678@qq.com");
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("基本信息认证：" + result);
    }

    /**
     * 进入上传身份证页
     */
    public static void enterAuthOcr() {
        String url = "http://mapi-" + namespace + ".liangkebang.net" + "/sc/auth/ocr/url";
        System.out.println(url);
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("x-auth-token", token);
        Map<String, Object> params = new HashMap<>();
        String returnUrl = "http://sc-" + namespace + ".liangkebang.net/auth-page";
        params.put("returnUrl", returnUrl);
        params.put("registerFrom", createdFrom);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("进入上传身份证页： " + result);
        Map respData = (Map) result.get("data");
        String respUrl = (String) respData.get("url");
        String[] split1 = respUrl.split("\\?");
        String[] split2 = split1[1].split("&");
        String[] split3 = split2[0].split("=");
        ocrToken = split3[1];
        System.out.println("OCR_token为：" + ocrToken);
    }

    /**
     * 上传身份证正面
     */
    public static void uploadFrontOfIdCard() {
        String url = "http://operator.liangkebang.com/auth-center/h5/api/ocr/auth.json";
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", ocrToken);
        Map<String, Object> params = new HashMap<>();
        params.put("img_str", "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");
        params.put("card_type", 0);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("上传身份证正面照：" + result);
    }

    /**
     * 上传身份证反面
     */
    public static void uploadBackOfIdCard() {
        String url = "http://operator.liangkebang.com/auth-center/h5/api/ocr/auth.json";
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", ocrToken);
        Map<String, Object> params = new HashMap<>();
        params.put("img_str", "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");
        params.put("card_type", 1);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("上传身份证反面：" + result);
    }

    /**
     * 提交拍照认证
     */
    public static void submitPhotoAuth() {
        String url = "http://operator.liangkebang.com/auth-center/h5/api/ocr/submit.json";
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", ocrToken);
        Map<String, Object> params = new HashMap<>();
        params.put("real_name", "刘志国");
        params.put("id_card_no", idCardNo);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("提交拍照认证：" + result);
    }

    /**
     * 授信
     */
    public static void credit() throws SQLException {
        String sql1 = "INSERT INTO user_auth_info ( auth_type, auth_account_name, user_id, auth_status) VALUES ( 0, '" + phone + "', '" + uuid + "', 1);";
        String sql2 = "INSERT INTO user_auth_info ( auth_type, auth_account_name, user_id, auth_status) VALUES (7, '" + phone + "', '" + uuid + "', 1);";
        String sql3 = "INSERT INTO user_auth_info ( auth_type, auth_account_name, user_id, auth_status) VALUES (16, '" + phone + "', '" + uuid + "', 1);";
        String sql4 = "INSERT INTO user_authorization (auth_type, user_id, auth_status) VALUES (15," + userId + ", 1);";
        System.out.println(sql1);
        System.out.println(sql2);
        System.out.println(sql3);
        System.out.println(sql4);
        DBUtils dbUtils = new DBUtils(namespace, "spider_center", "qa", "qatest");
        dbUtils.insert(sql1);
        dbUtils.insert(sql2);
        dbUtils.insert(sql3);
        dbUtils.insert(sql4);
    }

    /**
     * 查询授信中心id
     *
     * @throws SQLException
     */
    public static void queryCreditId() throws SQLException {
        String sql = "select id from user where phone_no = " + phone;
        DBUtils dbUtils = new DBUtils(namespace, "spider_center", "qa", "qatest");
        Map map = dbUtils.queryForMap(sql);
        System.out.println("查询授信中心id：" + map);
    }

    /**
     * 提交审核
     */
    public static void submitAudit() {
        String url = "http://scapi-" + namespace + ".liangkebang.net" + "/auth/submit";
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("x-auth-token", token);
        Map<String, Object> params = new HashMap<>();
        params.put("purpose", "-1");
        params.put("dimension", "");
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("提交审核结果：" + result);
    }

    /**
     * 查询用户审核记录
     */
    public static void queryUserAuditRecord() throws SQLException {
        String sql = "select channel,product_id,order_no,product_type from quota_credit where user_id = '" + userId + "' and is_active = 1 AND credit_status=1  order by id desc limit 1;";
        DBUtils dbUtils = new DBUtils(namespace, "xyqb", "qa", "qatest");
        Map result = dbUtils.queryForMap(sql);
        orderNo = result.get("order_no").toString().trim();
        productId = result.get("product_id").toString();
    }


    /**
     * 风控授信回调
     * 接口文档地址：http://open.quantgroups.com/project/44/interface/api/1204
     */
    public static void creditAuthNotify() {
        String url = "http://clotho-" + namespace + ".liangkebang.net" + "/external/quota/auth_amount_audit/notify";
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("x-auth-token", token);
        Map<String, Object> params = new HashMap<>();
        params.put("code", 0);
        params.put("msg", "success");
        params.put("bizChannel", channelId);  // 渠道号
        params.put("uuid", uuid);
        params.put("bizNo", orderNo);
        params.put("bizType", bizType);  // 业务类型： 0-现金分期一单一审，……
        params.put("auditResult", auditResult);
        params.put("amount", creditAmount);
        params.put("deadLine", "1607746332000");
        params.put("extData", "");
        params.put("otherInformation", "");
        JSONArray financeProducts = createFinanceProducts();
        params.put("financeProducts", financeProducts);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("风控授信回调参数：" + params);
        System.out.println("风控授信回调：" + result);
    }

    /**
     * 构造金融产品参数
     */
    public static JSONArray createFinanceProducts() {
        JSONArray financeProducts = new JSONArray();
        JSONObject financeProductsObject = new JSONObject();
        JSONArray terms = new JSONArray();
        financeProductsObject.put("max", maxAmount);
        financeProductsObject.put("min", minAmount);
        JSONObject firstTerm = new JSONObject();
        firstTerm.put("term", term);
        JSONArray fundInfoList = new JSONArray();
        JSONObject fundInfoObject = new JSONObject();
        fundInfoObject.put("fundId", fundId);
        fundInfoObject.put("rate", 0);
        fundInfoObject.put("rateType", 1);
        fundInfoObject.put("priority", 1);
        fundInfoObject.put("feeType", 1);
        // 云信判断
        if (fundId == 1040) {
            fundInfoObject.put("fundProductId", 1061);
        }
        fundInfoList.add(fundInfoObject);
        firstTerm.put("fundInfo", fundInfoList);
        terms.add(firstTerm);
        financeProductsObject.put("terms", terms);
        financeProducts.add(financeProductsObject);
        return financeProducts;
    }

    /**
     * 登录提现页
     */
    public static void loginWithDrawPage() {
        String url = "http://api-" + namespace + ".liangkebang.net" + "/v3/quota/account/pro/" + productId;
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("x-auth-token", token);
        JSONObject result = HttpClientUtils.doPost(url, null, headers);
        System.out.println("前往提现页：" + result);
    }

    /**
     * 查询accountId
     * @throws SQLException
     */
    public static void getUserAccountId() throws SQLException {
        String sql = "select id from quota_account where user_id = " + userId + " and product_id = " + productId;
        DBUtils dbUtils = new DBUtils(namespace, "xyqb", "qa", "qatest");
        List result = dbUtils.queryForList(sql);
        System.out.println("查询accountId：" + result);
        Map resMap = (Map) result.get(0);
        accountId = (Long)resMap.get("id");
        System.out.println(accountId);
    }

    /**
     * 绑卡
     */
    public static void bindCard() {
        String url = "http://api-" + namespace + ".liangkebang.net" + "/v3/bind_card/new";
        String callback = "http://api-" + namespace + ".liangkebang.net" + "/loan/cycle-card";
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("x-auth-token", token);
        Map<String, Object> params = new HashMap<>();
        params.put("accountId", accountId);
        params.put("cardType", 0);
        params.put("callback", callback);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("绑卡结果：" + result);
        String data = result.get("data").toString();
        String[] spilt1 = data.split("\\?");
        String[] split2 = spilt1[1].split("&");
        String[] split3 = split2[0].split("=");
        payToken = split3[1];
    }

    /**
     * 绑卡发送短信
     */
    public static void cardAuthSms() {
        String url = "http://payapi-" + namespace + ".liangkebang.net" + "/card_auth/sms";
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("x-auth-token", payToken);
        Map<String, Object> params = new HashMap<>();
        params.put("cardNo", cardNo);
        params.put("preservePhoneNo", phone);
        params.put("province", 110000);
        params.put("city", 110101);
        params.put("bankCode", "CCB");
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("绑卡发送短信：" + result);
    }

    /**
     * 绑卡确认
     */
    public static void cardAuthSmsConfirm() {
        String url = "http://payapi-" + namespace + ".liangkebang.net" + "/card_auth/sms_confirm";
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("x-auth-token", payToken);
        Map<String, Object> params = new HashMap<>();
        params.put("cardNo", cardNo);
        params.put("province", 110000);
        params.put("city", 110101);
        params.put("validateCode", "000000");
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("绑卡确认：" + result);
    }

    /**
     * 获取绑卡列表
     */
    public static void getBindCardList() throws URISyntaxException {
        String url = "http://api-" + namespace + ".liangkebang.net" + "/v3/bind_card/list?accountId=" + accountId + "&cardType=0";
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", token);
        JSONObject resp = HttpClientUtils.doGetReturnJson(url, null, headers);
        List cardList = (List) resp.get("data");
        Map firstCard = (Map) cardList.get(0);
        cardId = (Integer) firstCard.get("id");
        cardBindInfoId = (Integer) firstCard.get("cardBindInfoId");
        System.out.println("获取绑卡列表：" + resp);
    }

    /**
     * 绑卡后提现
     */
    public static void createLoan() {
        String url = "http://api-" + namespace + ".liangkebang.net" + "/v3/quota/loan/createLoan";
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("x-auth-token", token);
        Map<String, Object> params = new HashMap<>();
        params.put("amount", maxAmount);
        params.put("term", term);
        params.put("accountId", accountId);
        params.put("productId", productId);
        params.put("cardId", cardId);
        params.put("cardBindInfoId", cardBindInfoId);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("绑卡后提现：" + result);
        Map respData = (Map) result.get("data");
        loanId = (Integer) respData.get("loanId");
    }

    /**
     * 二次风控
     */
    public static void externalQuotaOrderAuditNotify() {
        String url = "http://clotho-" + namespace + ".liangkebang.net" + "/external/quota/order_audit/notify";
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("x-auth-token", token);
        Map<String, Object> params = new HashMap<>();
        params.put("code", 0);
        params.put("msg", "success");
        params.put("bizChannel", 1);
        params.put("uuid", uuid);
        params.put("bizNo", loanId);
        params.put("bizType", bizType);
        params.put("auditResult", true);
        params.put("deadLine", "1548518400");
        System.out.println(params);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("二次风控：" + result);
    }

    /**
     * 修改合同状态
     */
    public static void modifyContactStatus() throws SQLException {
        String sql = "update contract set generate_status = 2 where user_id = " + userId;
        DBUtils dbUtils = new DBUtils(namespace, "xyqb", "qa", "qatest");
        Integer response = dbUtils.insert(sql);
        System.out.println("修改合同状态：" + response);
    }

    /***
     * 登录OP
     */
    public static void loginOP() {
        String url = "http://opapi-" + namespace + ".liangkebang.net" + "/user/login?auth=dXNlcj1xYSZwYXNzd29yZD1xYXRlc3Q=";
        JSONObject result = HttpClientUtils.doGetReturnJson(url);
        System.out.println("登录OP：" + result);
        Map data = (Map) result.get("data");
        opToken = data.get("token").toString();
    }

    /**
     * 查询待打款数量
     * @throws SQLException
     */
    public static void checkWaitingFundingCorpOperatePeople() throws SQLException {
        String sql = "select sum(fund_amount) as money ,count(*) as people from xyqb.waiting_funding_corp_operate_people where funding_corp_progress=0 and funding_corp_id= " + fundId;
        DBUtils dbUtils = new DBUtils(namespace, "xyqb", "qa", "qatest");
        Map map = dbUtils.queryForMap(sql);
        System.out.println(map);
//        String[] dataList = (String[]) map.get("data");
//        String[] result = dataList[0].split(",");
//        money = Integer.parseInt(result[0]);
//        assignPeopleNum = Integer.parseInt(result[1]);
        BigDecimal bigDecimal = new BigDecimal(map.get("money").toString());
        money = bigDecimal.intValue();
        assignPeopleNum = Integer.parseInt(map.get("people").toString());
    }

    /**
     * 修改待放款用户创建时间
     */
    public static void modifyWaitingFundingCreatedAt() throws SQLException {
        String sql = "update waiting_funding_corp_operate_people set created_at = DATE_SUB(created_at, interval 5 minute) where loan_application_history_id = " + loanId;
        System.out.println(sql);
        DBUtils dbUtils = new DBUtils(namespace, "xyqb", "qa", "qatest");
        Integer response = dbUtils.insert(sql);
        System.out.println("修改待放款用户创建时间："  + response);
    }

    /**
     * 直接打款
     */
    public static void fundsPlanLoanApply() {
        String url = "http://opapi-" + namespace + ".liangkebang.net" + "/clotho/funds/plan/loan/apply";
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("x-auth-token", opToken);
        Map<String, Object> params = new HashMap<>();
        params.put("fundingCorpId", fundId);
        params.put("amountLimit", money);
        params.put("peopleLimit", assignPeopleNum);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("直接打款：" + result);
    }

    /**
     * 放款结果通知
     */
    public static void payNotify() {
        String url = "http://api-" + namespace + ".liangkebang.net" + "/ex/paycenter/pay_notify";
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Map<String, Object> params = new HashMap<>();
        params.put("orderNo", loanId);
        params.put("payOrderNo", loanId);
        params.put("payTime", System.currentTimeMillis());
        params.put("payStatus", 3);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("请求参数：" + params);
        System.out.println("放款结果通知：" + result)  ;
    }

    /**
     * 登录资金方OP
     */
    public static void loginFundOP() {
        String url = "http://opapi-" + namespace + ".liangkebang.net" + "/user/login";
        Map<String, Object> map = new HashMap<>();
        map.put("auth", "dXNlcj1xYSZwYXNzd29yZD1xYXRlc3Q=");
        String params = JSON.toJSONString(map);
        JSONObject result = HttpClientUtils.doPostJson(url, params);
        Map data = (Map) result.get("data");
        fundOpToken = data.get("token").toString();
        System.out.println("返回结果为：" + result);
    }

    /**
     * 分配资产计划
     */
    public static void setFundPlan() {
        String url = "http://opapi-" + namespace + ".liangkebang.net" + "/clotho/funds/plan/funding/plan/save";
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String today = formatter.format(date);
        Map<String, Object> params = new HashMap<>();
        params.put("fundCorpId", fundId);
        params.put("planDate", today);
        params.put("maxAssignAmount", 10000000);
        params.put("maxLoanAmount", 10000000);
        params.put("maxLoanPeople", 100);
        params.put("maxAssignPeople", 100);
        params.put("priorityLevel", 1);
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", fundOpToken);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("分配资金方的结果为：" + result);
    }

    /**
     * 打开推送放款
     */
    public static void unblockLoan() {
        String url = "http://opapi-" + namespace + ".liangkebang.net" + "/clotho/funds/plan/funding/switch/" + fundId + "/loan/auto_lock";
        Map<String, Object> params = new HashMap<>();
        params.put("to", true);
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", fundOpToken);
        JSONObject result = HttpClientUtils.doPost(url, params, headers);
        System.out.println("推送放款URL：" + url);
        System.out.println("推送放款Enable：" + result);
    }

    /**
     * 判断是否已经分配资金方
     */
    public static boolean assignFundOrNot() throws URISyntaxException {
        boolean flag = false;
        String url = "http://opapi-" + namespace + ".liangkebang.net" + "/clotho/funds/plan/funding/asset/week/0";
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", fundOpToken);
        JSONObject result = HttpClientUtils.doGetReturnJson(url, null, headers);
        System.out.println(result);
        Map data = (Map) result.get("data");
        if (data.isEmpty()) {
            return false;
        }
        List<Map> dataList = (List<Map>) data.get(fundId.toString());
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String today = formatter.format(date);
        if (dataList != null) {
            for (int i=0; i < dataList.size(); i++) {
                if (dataList.get(i).get("planDate").toString().equals(today)) {
                    flag = true;
                }
            }
        }
        System.out.println("资金方是否已经分配：" + flag);
        return flag;
    }

    /**
     * 云信插入银行卡
     */
    public static void insertBankCardOfYunxing() throws SQLException {
        String sql = "INSERT INTO `card_check_record`(`user_id`, `card_no`, `bank_code`, `bank_name`, `branch_no`, `branch_name`, `province`, `city`, `card_type`, `is_active`, `created_at`, `updated_at`) VALUES (" + userId + ", '6222988108217968', 'PINGAN', '平安银行', NULL, NULL, NULL, NULL, 2, 1, '2020-08-13 14:04:27', '2020-08-13 14:04:27');";
        System.out.println(sql);
        DBUtils dbUtils = new DBUtils(namespace, "payment_center", "qa", "qatest");
        Integer result = dbUtils.insert(sql);
        System.out.println("云信插入银行卡结果：" + result);
    }


    public static void main(String[] args) throws Exception {
        // 分配资金方
        loginFundOP();
        unblockLoan();
        boolean result = assignFundOrNot();
        if (!result) {
            setFundPlan();
            unblockLoan();
        }

        // 授信
        login();
        checkUserId();
        // 如果是云信，则需要插入银行卡
        if (fundId == 1040) {
            insertBankCardOfYunxing();
        }
        syncSessionToXyqb();
        creditSessionSync();
        realNameVerified();
        authBasicInfo();
        enterAuthOcr();
        uploadFrontOfIdCard();
        uploadBackOfIdCard();
        submitPhotoAuth();
        credit();
        submitAudit();
        queryUserAuditRecord();
        creditAuthNotify();
        Thread.sleep(180000);

        // 绑卡提现
        login();
        checkUserId();
        syncSessionToXyqb();
        loginWithDrawPage();
        getUserAccountId();
        bindCard();
        cardAuthSms();
        cardAuthSmsConfirm();
        getBindCardList();
        createLoan();
        externalQuotaOrderAuditNotify();
        modifyContactStatus();
        Thread.sleep(10000);

        // 放款
        loginOP();
        checkWaitingFundingCorpOperatePeople();
        modifyWaitingFundingCreatedAt();
        Thread.sleep(10000);
        fundsPlanLoanApply();
        Thread.sleep(10000);
        payNotify();

    }
}
