package cn.qg.qaplatform.service;

import cn.qg.qaplatform.domain.ApplyLoanInfo;
import cn.qg.qaplatform.domain.GenLoanUser;

import java.io.IOException;
import java.sql.SQLException;

public interface GenUserDataService {

    /**
     * 分配资金方
     */
    boolean assignFundCorp(String namespace, Integer fundId, String symbol) throws IOException;

    /**
     * 授信
     * @param applyLoanInfo 造数据的相关信息
     * @return 成功或失败
     */
    boolean quotaAuth(ApplyLoanInfo applyLoanInfo, boolean auditResult) throws Exception;

    /**
     * 提现
     * @param applyLoanInfo 造数据相关信息
     * @return 成功或失败
     */
    boolean withDraw(ApplyLoanInfo applyLoanInfo, boolean auditResult) throws Exception;

    /**
     * 放款
     * @param applyLoanInfo
     * @return
     */
    boolean makeLoan(ApplyLoanInfo applyLoanInfo,  boolean payStatus) throws Exception;

    /**
     * 造数据
     * @param applyLoanInfo
     * @return
     * @throws Exception
     */
    boolean genLoanUser(ApplyLoanInfo applyLoanInfo) throws Exception;

    /**
     * 获取用户状态
     * @param namespace
     * @param phoneNo
     * @return
     */
    GenLoanUser queryUserStatus(String namespace, String phoneNo);

}
