package cn.qg.qaplatform.service.impl;

import cn.qg.qaplatform.config.WebSocketServer;
import cn.qg.qaplatform.domain.ApplyLoanInfo;
import cn.qg.qaplatform.domain.GenLoanUser;
import cn.qg.qaplatform.process.xyqb.MainProcess;
import cn.qg.qaplatform.service.GenUserDataService;
import cn.qg.qaplatform.service.QueryBasicLoanStatusDataService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;


@Service
@Slf4j
public class GenUserDataServiceImpl implements GenUserDataService {

    @Resource
    RedisTemplate redisTemplate;

    @Autowired
    QueryBasicLoanStatusDataService queryBasicLoanStatusDataService;

    /**
     * 分配资产计划
     * @param namespace
     * @param fundId
     * @return
     */
    @Override
    public boolean assignFundCorp(String namespace, Integer fundId, String symbol) throws IOException {
        MainProcess.symbol = symbol;
        // 登录资金方OP
        String fundOpToken = MainProcess.loginFundOP(namespace);
        boolean isAleadyAssign = false;
        // 检查是否已分配资产计划
        try {
            isAleadyAssign = MainProcess.assignFundOrNot(namespace, fundId, fundOpToken);
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        boolean assignResult = false;
        boolean unblockResult = false;
        // 如果未分配
        if (!isAleadyAssign) {
            // 分配资产计划
            assignResult = MainProcess.setFundPlan(namespace, fundId, fundOpToken);
            // 打开推送放款
            unblockResult = MainProcess.unblockLoan(namespace, fundId, fundOpToken);
            if (assignResult && unblockResult) {
                return true;
            }
            return false;
        } else {
            return true;
        }
    }

    /**
     * 授信
     * @param applyLoanInfo 造数据的相关信息
     * @return
     * @throws Exception
     */
    @Override
    public boolean quotaAuth(ApplyLoanInfo applyLoanInfo, boolean auditResult) throws Exception {
        String namespace = applyLoanInfo.getNamespace();
        String phoneNo = applyLoanInfo.getPhoneNo();
        Integer channelId = applyLoanInfo.getChannel();
        Integer fundId = applyLoanInfo.getFundId();
        Integer amount = applyLoanInfo.getAmount();
        Integer term = applyLoanInfo.getTerm();
        String symbol = applyLoanInfo.getSymbol();
        String name = applyLoanInfo.getName();
        String idNo = applyLoanInfo.getIdNo();

        // 登录
        String token = MainProcess.login(namespace, channelId, phoneNo);
        // 查询用户中心id
        Map map = MainProcess.checkUserId(namespace, phoneNo);
        String uuid = map.get("uuid").toString();
        String userId = map.get("id").toString();
        // 同步session到xyqb
        MainProcess.syncSessionToXyqb(namespace, token);
        // 授信session同步
        MainProcess.creditSessionSync(namespace, "1", token);
        // 实名认证
        MainProcess.realNameAuth(namespace, token, name, idNo);
        // 基本信息认证
        MainProcess.authBasicInfo(namespace, token);
        // 进入上传身份证页
        String ocrToken = MainProcess.enterAuthOcr(namespace, token);
        // 上传身份证正面
        MainProcess.uploadFrontOfIdCard(ocrToken);
        // 上传身份证反面
        MainProcess.uploadBackOfIdCard(ocrToken);
        // 提交拍照认证
        MainProcess.submitPhotoAuth(ocrToken);
        // 授信
        MainProcess.credit(namespace, phoneNo, userId, uuid);
        // 提交审核
        MainProcess.submitAudit(namespace, token);
        // 查询用户审核记录
        Map authResult = MainProcess.queryUserAuditRecord(namespace, userId);
        String orderNo = authResult.get("order_no").toString().trim();
        String productId = authResult.get("product_id").toString();
        // 风控授信回调
        boolean creditResult = MainProcess.creditAuthNotify(namespace, token, uuid, channelId, fundId, orderNo, 0, auditResult, amount, term);
        // 风控授信回调成功，redis值为0
        if (creditResult) {
            setUserStatusRedisValue(namespace, phoneNo, 0);
        } else {
            setUserStatusRedisValue(namespace, phoneNo, 1);
        }
        return creditResult;
    }

    /**
     * 提现
     * @param applyLoanInfo 造数据相关信息
     * @param auditResult 二次风控成功or失败
     * @return
     * @throws Exception
     */
    @Override
    public boolean withDraw(ApplyLoanInfo applyLoanInfo, boolean auditResult) throws Exception {
        String namespace = applyLoanInfo.getNamespace();
        String phoneNo = applyLoanInfo.getPhoneNo();
        Integer channelId = applyLoanInfo.getChannel();
        Integer fundId = applyLoanInfo.getFundId();
        Integer amount = applyLoanInfo.getAmount();
        Integer term = applyLoanInfo.getTerm();
        String cardNo = applyLoanInfo.getCardNo();
        String bankCode = applyLoanInfo.getBankCode();

        // 登录
        String token = MainProcess.login(namespace, channelId, phoneNo);
        // 查询用户中心id
        Map map = MainProcess.checkUserId(namespace, phoneNo);
        String uuid = map.get("uuid").toString();
        String userId = map.get("id").toString();
        // 同步session到xyqb
        MainProcess.syncSessionToXyqb(namespace, token);
        // 查询用户审核记录
        Map authResult = MainProcess.queryUserAuditRecord(namespace, userId);
        String orderNo = authResult.get("order_no").toString().trim();
        String productId = authResult.get("product_id").toString();
        Long accountId;
        // 查询accountId
        try {
            accountId = MainProcess.getUserAccountId(namespace, userId, productId);
        } catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            log.info("资方分配失败，quota_account表中无法查询到accountId!");
            return false;
        }
        // 绑卡
        String payToken = MainProcess.bindCard(namespace, token, accountId);
        // 绑卡发送短信
        MainProcess.cardAuthSms(namespace, payToken, phoneNo, cardNo, bankCode);
        // 绑卡确认
        MainProcess.cardAuthSmsConfirm(namespace, payToken, cardNo);
        // 获取绑卡列表
        Map firstCard = MainProcess.getBindCardList(namespace, token, accountId);
        Integer cardId = (Integer) firstCard.get("id");
        Integer cardBindInfoId = (Integer) firstCard.get("cardBindInfoId");
        // 绑卡后提现
        Integer loanId = MainProcess.createLoan(namespace, token, amount, term, accountId, productId, cardId, cardBindInfoId);
        // 平顶山银行不需要发起二次风控
        if (fundId == 1030 && loanId !=null) {
            return true;
        }
        // 二次风控
        boolean result = MainProcess.externalQuotaOrderAuditNotify(namespace, token, uuid, loanId, 0, auditResult);
        // 修改合同状态
        MainProcess.modifyContactStatus(namespace, userId);
        if (result) {
            setUserStatusRedisValue(namespace, phoneNo, 2);
        }
        return result;
    }

    /**
     * 放款
     * @param applyLoanInfo
     * @return
     */
    @Override
    public boolean makeLoan(ApplyLoanInfo applyLoanInfo, boolean payStatus) throws Exception {
        String namespace = applyLoanInfo.getNamespace();
        String phoneNo = applyLoanInfo.getPhoneNo();
        Integer channelId = applyLoanInfo.getChannel();
        Integer fundId = applyLoanInfo.getFundId();
        Integer amount = applyLoanInfo.getAmount();
        Integer term = applyLoanInfo.getTerm();

        // 登录
        String token = MainProcess.login(namespace, channelId, phoneNo);
        // 查询用户中心id
        Map map = MainProcess.checkUserId(namespace, phoneNo);
        String uuid = map.get("uuid").toString();
        String userId = map.get("id").toString();

        // 登录OP，获取token
        String opToken = MainProcess.loginOP(namespace);
        // 查询待打款数量
        Map<String, Integer> peopleMap = MainProcess.checkWaitingFundingCorpOperatePeople(namespace, fundId);
        Integer money = peopleMap.get("money");
        Integer people = peopleMap.get("people");
        // 修改待放款用户创建时间
        Integer loanId = MainProcess.getLoanId(namespace, userId);
        MainProcess.modifyWaitingFundingCreatedAt(namespace, loanId);
        Thread.sleep(5000);
        // 直接打款
        MainProcess.fundsPlanLoanApply(namespace,opToken, fundId, money, people);
        Thread.sleep(30000);
        // 放款结果通知
        boolean makeLoanResult = MainProcess.payNotify(namespace, loanId, payStatus);
        if (makeLoanResult) {
            setUserStatusRedisValue(namespace, phoneNo, 3);
        } else {
            setUserStatusRedisValue(namespace, phoneNo, 4);
        }
        return makeLoanResult;
    }

    /**
     * 设置redis值，查询状态
     * @param namespace
     * @param phoneNo
     * @param status 0-授信成功，1-授信失败，2-提现成功，3-放款成功，4-放款失败
     */
    public void setUserStatusRedisValue(String namespace, String phoneNo, Integer status) {
        String redisKey = namespace + "_" + phoneNo;
        redisTemplate.opsForValue().set(redisKey, status);
    }

    /**
     * 查询资方分配进度
     */
    public void queryFundingAssignProgress(String namespace, String userId, Integer fundId, String symbol) throws InterruptedException {
        while (true) {
            Integer searchResult = queryBasicLoanStatusDataService.getAssignFundIdByUserId(namespace, userId);
            log.info(searchResult.toString());
            if (fundId.equals(searchResult)) {
                log.info("用户：" + userId + "资方分配成功!");
                if (!StringUtils.isEmpty(symbol)) {
                    WebSocketServer.sendInfo("查询到的资方为：" + searchResult +",资方分配成功.", symbol);
                }
                break;
            } else {
                if (!StringUtils.isEmpty(symbol)) {
                    WebSocketServer.sendInfo("查询到的资方为：" + searchResult +",资方还未分配成功，10秒后重试", symbol);
                }
                Thread.sleep(10000);
            }
        }
    }

    /**
     * 查询用户放款状态
     * @param namespace
     * @param userId
     * @param symbol
     */
    public void queryLoanProgress(String namespace, String userId, String symbol) throws InterruptedException {
        while (true) {
            Integer progress = queryBasicLoanStatusDataService.getLoanProgressByUserId(namespace, userId);
            if (progress == 15) {
                log.info("用户：" + userId + "放款成功！");
                if (!StringUtils.isEmpty(symbol)) {
                    WebSocketServer.sendInfo("放款成功.", symbol);
                }
                break;
            } else {
                if (!StringUtils.isEmpty(symbol)) {
                    WebSocketServer.sendInfo("查询到的状态为：" + progress + "，资方放款中，30秒后重新查询状态！", symbol);
                }
                Thread.sleep(30000);
            }
        }
    }

    @Override
    public boolean genLoanUser(ApplyLoanInfo applyLoanInfo) throws Exception {
        Integer status = applyLoanInfo.getStatus();
        String namespace = applyLoanInfo.getNamespace();
        Integer fundId = applyLoanInfo.getFundId();
        String symbol = applyLoanInfo.getSymbol();
        String phoneNo = applyLoanInfo.getPhoneNo();

        WebSocketServer.sendInfo("本次请求的参数为：" + applyLoanInfo.toString(), symbol);
        log.info("本次请求的参数为：" + applyLoanInfo.toString());

        boolean assignFundResult = assignFundCorp(namespace, fundId, symbol);
        log.info("分配资金方的结果为：" + assignFundResult);

        /**
         * 0 - 审核通过
         */
        if (status == 0) {
            return quotaAuth(applyLoanInfo, true);
        }

        /**
         * 1 - 审核拒绝
         */
        if (status == 1) {
            return quotaAuth(applyLoanInfo, false);
        }

        /**
         * 2 - 放款中
         */
        if (status == 2) {
            boolean result = quotaAuth(applyLoanInfo, true);
            if (!result) {
                return false;
            }
            String userId = queryBasicLoanStatusDataService.getUserInfoByPhoneNo(namespace, phoneNo).getUserId();
            // 查询资方审核进度，如未分配成功，则阻塞下一步
            queryFundingAssignProgress(namespace, userId, fundId, symbol);
            return withDraw(applyLoanInfo, true);
        }

        /**
         * 3 - 放款成功
         */
        if (status == 3) {
            boolean quotaAuthResult = quotaAuth(applyLoanInfo, true);
            if (!quotaAuthResult) {
                return false;
            }
            String userId = queryBasicLoanStatusDataService.getUserInfoByPhoneNo(namespace, phoneNo).getUserId();
            // 查询资方审核进度，如未分配成功，则阻塞下一步
            queryFundingAssignProgress(namespace, userId, fundId, symbol);
            boolean withDrawResult =  withDraw(applyLoanInfo, true);
            if (!withDrawResult) {
                WebSocketServer.sendInfo("提现失败!", symbol);
                return false;
            }
            // 如果资方选择云信，则不需要手动调放款
            if (fundId == 1040) {
                WebSocketServer.sendInfo("提现成功，等待云信放款...", namespace);
                queryLoanProgress(namespace, userId, symbol);
                setUserStatusRedisValue(namespace, phoneNo, 3); // 因为没有调放款广达放款接口，因此需要手动设置redis值
                return true;
            }
            WebSocketServer.sendInfo("提现成功，10秒后放款!", symbol);
            Thread.sleep(10000);
            // 广达小贷-手动放款
            boolean makeLoanResult = makeLoan(applyLoanInfo, true);
            if (makeLoanResult) {
                WebSocketServer.sendInfo("放款成功!", symbol);
            } else {
                WebSocketServer.sendInfo("放款失败!", symbol);
            }
            return makeLoanResult;
        }

        /**
         * 4 - 放款失败
         */
        if (status == 4) {
            boolean quotaAuthResult = quotaAuth(applyLoanInfo, true);
            if (!quotaAuthResult) {
                return false;
            }
            String userId = queryBasicLoanStatusDataService.getUserInfoByPhoneNo(namespace, phoneNo).getUserId();
            // 查询资方审核进度，如未分配成功，则阻塞下一步
            queryFundingAssignProgress(namespace, userId, fundId, symbol);
            // 云南信托：二次风控失败，即代表放款失败
            if (fundId == 1040) {
                withDraw(applyLoanInfo, false);
                WebSocketServer.sendInfo("放款失败！", symbol);
                setUserStatusRedisValue(namespace, phoneNo, 4);
                return true;
            }
            boolean withDrawResult =  withDraw(applyLoanInfo, true);
            if (!withDrawResult) {
                WebSocketServer.sendInfo("提现失败!", symbol);
                return false;
            }
            WebSocketServer.sendInfo("提现成功，10秒后放款!", symbol);
            Thread.sleep(10000);
            boolean makeLoanResult = makeLoan(applyLoanInfo, false);
            if (makeLoanResult) {
                WebSocketServer.sendInfo("放款失败!", symbol);
            }
            return makeLoanResult;

        }
        return false;
    }

    @Override
    public GenLoanUser queryUserStatus(String namespace, String phoneNo) {
        String redisResult = redisTemplate.opsForValue().get(namespace + "_" + phoneNo).toString();
        log.info("获取redis key结果为：" + redisResult);
        GenLoanUser genLoanUser = new GenLoanUser();
        genLoanUser = queryBasicLoanStatusDataService.getUserInfoByPhoneNo(namespace, phoneNo);
        genLoanUser.setFundId(queryBasicLoanStatusDataService.getAssignFundIdByUserId(namespace, genLoanUser.getUserId()));
        // 授信审核中
        if (redisResult.equals("0")) {
            genLoanUser.setStatus(0);
            genLoanUser.setDesc("授信审核中");
        }
        // 授信审核失败
        if (redisResult.equals("1")) {
            genLoanUser.setStatus(1);
            genLoanUser.setDesc("授信审核失败");
        }
        // 提现成功
        if (redisResult.equals("2")) {
            // 设置资方id
            genLoanUser.setStatus(2);
            genLoanUser.setDesc("提现成功");
        }
        // 提现失败
        if (redisResult.equals("10")) {
            genLoanUser.equals("10");
            genLoanUser.setDesc("资方分配失败");
        }
        // 放款成功
        if (redisResult.equals("3")) {
            genLoanUser.setStatus(3);
            genLoanUser.setDesc("放款成功");
        }
        // 放款失败
        if (redisResult.equals("4")) {
            genLoanUser.setStatus(4);
            genLoanUser.setDesc("放款失败");
        }
        return genLoanUser;
    }


}
