package cn.qg.qaplatform.service.xyqb.impl;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.entity.xyqb.LoanApplicationHistory;
import cn.qg.qaplatform.mapper.xyqb.LoanApplicationHistoryMapper;
import cn.qg.qaplatform.service.xyqb.LoanApplicationHistoryService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoanApplicationHistoryServiceImpl extends ServiceImpl<LoanApplicationHistoryMapper, LoanApplicationHistory>
        implements LoanApplicationHistoryService {

    @Autowired
    LoanApplicationHistoryMapper loanApplicationHistoryMapper;

    @Override
    public LoanApplicationHistory getLastestLoanByUserId(String namespace, String userId) {
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb");
        QueryWrapper<LoanApplicationHistory> queryWrapper = new QueryWrapper<>();
        queryWrapper
                .eq("user_id", userId)
                .orderByDesc("id")
                .last("limit 1");
        return loanApplicationHistoryMapper.selectOne(queryWrapper);
    }
}
