package cn.qg.qaplatform.service.impl;

import cn.qg.qaplatform.common.enums.ChannelEnum;
import cn.qg.qaplatform.domain.ApplyDataVo;
import cn.qg.qaplatform.process.Common;
import cn.qg.qaplatform.process.Lexin;
import cn.qg.qaplatform.process.Xyqb;
import cn.qg.qaplatform.service.QueryInProcessStatusService;
import cn.qg.qaplatform.service.LexinDataService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
@Slf4j
public class LexinDataServiceImpl implements LexinDataService {
    @Autowired
    QueryInProcessStatusService queryInProcessStatusService;

    @Autowired
    RedisTemplate redisTemplate;

    @Override
    public boolean genLexinData(ApplyDataVo applyDataVo) throws Exception {
        String namespace = applyDataVo.getNamespace();
        String phoneNo = applyDataVo.getPhoneNo();
        String bankCardNo = applyDataVo.getBankCardNo();
        String bankCode = applyDataVo.getBankCode();
        String bankName = applyDataVo.getBankName();
        Integer fundId = applyDataVo.getFundId();
        String symbol = applyDataVo.getSymbol();
        Integer amount = applyDataVo.getAmount();
        Integer term = applyDataVo.getTerm();
        Xyqb.symbol = symbol;
        // 分配资产计划
        boolean fundAssignResult = Common.assignFundCorp(namespace, fundId);
        // 进件
        boolean createOrderResult = Lexin.createOrder(applyDataVo);
        setUserStatusRedisValue(namespace, phoneNo, 0);
        if (!createOrderResult) {
            return false;
        }
        String channelOrderNo = Common.queryChannelOrderNoByPhone(namespace, phoneNo, ChannelEnum.LEXIN.getChannelId());
        Common.channelOrderApprove(namespace, channelOrderNo, amount, "0", true, term);
        // 查询到资方分配成功才进行下一步
        queryInProcessStatusService.queryFundingAssignProgress(namespace, phoneNo, fundId, symbol);
        // api提现
        boolean withDrawResult = Common.withDraw(namespace, "LEXIN", channelOrderNo, bankCardNo, bankCode, bankName, phoneNo);
        if (!withDrawResult) {
            return false;
        }
        setUserStatusRedisValue(namespace, phoneNo, 2);
        // 二次风控
        String token = Xyqb.login(namespace, 1, phoneNo);
        Map userInfoResult = Xyqb.checkUserId(namespace, phoneNo);
        String uuid = userInfoResult.get("uuid").toString();
        String userId = userInfoResult.get("id").toString();
        Integer loanId = Common.queryLoanId(namespace, phoneNo, ChannelEnum.LEXIN.getChannelId());
        boolean secondWindControlResult = Xyqb.externalQuotaOrderAuditNotify(namespace, 1, token, uuid, loanId, 11, true);
        Xyqb.modifyContactStatus(namespace, userId);
        // 放款
        String opToken = Xyqb.loginOP(namespace);
        // 查询待打款数量
        Map<String, Integer> peopleMap = Xyqb.checkWaitingFundingCorpOperatePeople(namespace, fundId);
        Integer money = peopleMap.get("money");
        Integer people = peopleMap.get("people");
        // 修改待放款用户创建时间
        Xyqb.modifyWaitingFundingCreatedAt(namespace, loanId);
        Thread.sleep(5000);
        // 直接打款
        Xyqb.fundsPlanLoanApply(namespace,opToken, fundId, money, people);
        Thread.sleep(30000);
        // 放款结果通知
        boolean makeLoanResult = Xyqb.payNotify(namespace, loanId, true);
        setUserStatusRedisValue(namespace, phoneNo, 3);
        return makeLoanResult;
    }

    public void setUserStatusRedisValue(String namespace, String phoneNo, Integer status) {
        String redisKey = namespace + "_" + phoneNo;
        redisTemplate.opsForValue().set(redisKey, status);
    }
}
