package cn.qg.qaplatform.controller.stools;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.entity.stools.MsgSendVo;
import cn.qg.qaplatform.entity.stools.MsgTemplate;
import cn.qg.qaplatform.service.stools.MsgService;
import cn.qg.qaplatform.utils.JsonResult;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 消息中心相关接口
 * @author libo
 * 2021-08-13
 */
@RestController
@RequestMapping("/msg")
public class MsgController {

    @Autowired
    MsgService msgService;

    /**
     * 发送push
     * @param msgSendVo
     * @return
     */
    @PostMapping("/send/push")
    public JsonResult sendPush(@RequestBody MsgSendVo msgSendVo) {
        return JsonResult.success(msgService.sendPush(msgSendVo.getNamespace(), msgSendVo.getPhoneNo(), msgSendVo.getContentId(), msgSendVo.getContentArgs()));
    }

    /**
     * 发送站内信
     * @param msgSendVo
     * @return
     */
    @PostMapping("/send/stationLetter")
    public JsonResult sendStationLetter(@RequestBody MsgSendVo msgSendVo) {
        return JsonResult.success(msgService.sendStationLetter(msgSendVo.getNamespace(), msgSendVo.getPhoneNo(), msgSendVo.getContentId(), msgSendVo.getContentArgs()));
    }

    /**
     * 发送行业短信
     * @param msgSendVo
     * @return
     */
    @PostMapping("/send/quick")
    public JsonResult sendMsgQuick(@RequestBody MsgSendVo msgSendVo) {
        return JsonResult.success(msgService.sendMsgQuick(msgSendVo.getNamespace(), msgSendVo.getPhoneNo(), msgSendVo.getContentId(), msgSendVo.getContentArgs()));
    }

    @PostMapping("/send/market")
    public JsonResult sendMsgMarket(@RequestBody MsgSendVo msgSendVo) {
        return JsonResult.success(msgService.sendMsgQuick(msgSendVo.getNamespace(), msgSendVo.getPhoneNo(), msgSendVo.getContentId(), msgSendVo.getContentArgs()));
    }

    /**
     * 获取短信模板列表
     * @param namespace
     * @param templateType
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/template/list")
    public JsonResult getMsgTemplateList(String namespace, Integer templateType, Integer pageNum, Integer pageSize) {
        SwitchDataSource.dataSourceSwitch(namespace, "msg");
        Page<MsgTemplate> page = new Page<>(pageNum, pageSize);
        QueryWrapper<MsgTemplate> msgTemplateQueryWrapper = new QueryWrapper<>();
        msgTemplateQueryWrapper.eq("template_type", templateType);
        IPage<MsgTemplate> msgTemplateIPage = msgService.page(page, msgTemplateQueryWrapper);
        Map<String, Object> map = new HashMap<>();
        map.put("total", msgTemplateIPage.getTotal());
        map.put("list", msgTemplateIPage.getRecords());
        return JsonResult.success(map);
    }
}
