package cn.quantgroup.qaplatform.dao;


import cn.quantgroup.qaplatform.domain.LoanUser;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import java.util.List;

public interface QueryBasicLoanStatusDataMapper {

    /**
     * 根据uuidList获取用户数据信息
     * @param uuidList
     * @return
     */
    List<LoanUser> getUserDataListByUuidList(List<String> uuidList);

    /**
     * 获取未申请用户数据uuidList
     */
    List<String> getUnApplyLoanUserUuidList(Integer channel);

    /**
     * 判断手机号是否存在库里
     */
    Object queryIfPhoneExist(String phone);


    /**
     * 根据userIdList获取用户信息列表
     * @param userIdList
     * @return
     */
    List<LoanUser> getUserDataListByUserIdList(List<String> userIdList);

    /**
     * 根据审核状态获取用户Id列表
     * @param status 0-审核中，1-审核拒绝，2-审核通过
     * @return
     */
    List<String> getAuditStatusUserIdList(Integer status, Integer channel);

    /**
     * 根据资方和渠道id查询审核通过未提现的用户
     * @param channel
     * @param fundId
     * @return
     */
    List<String> queryAuthAndUnWithdraw(Integer channel, Integer fundId);

    /**
     * 根据借款状态获取用户列表
     * @param progress 20-放款中，15-放款成功，23-放款失败
     * @return
     */
    List<String> getLoanStatusUserIdList(Integer progress, Integer channel, Integer fundId);

    /**
     * 获取多订单用例id列表
     * @return
     */
    List<String> getMultiOrderuuidList();
}
