package cn.qg.qaplatform.automation.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 接口实体类
 */
@Data
public class Interface {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 接口名称
     */
    private String name;

    /**
     * 接口路径
     */
    private String url;

    /**
     * 请求方法
     */
    private String method;

    /**
     * 参数类型
     */
    private String paramsType;

    private Integer moduleId;

    private Integer projectId;

    /**
     * 创建者
     */
    private String author;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @TableField(exist = false)
    private String projectName;

    @TableField(exist = false)
    private String moduleName;
}

