package cn.qg.qaplatform.automation.controller;

import cn.qg.qaplatform.automation.domain.Module;
import cn.qg.qaplatform.automation.service.ModuleService;
import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.utils.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@CrossOrigin
@RestController
@RequestMapping("/module")
public class ModuleController {
    @Autowired
    ModuleService moduleService;

    @GetMapping("/list")
    public  JsonResult getModuleList() {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(moduleService.list());
    }

    @PostMapping("/add")
    public JsonResult addModule(@RequestBody Module module) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(moduleService.save(module));
    }

    @PostMapping("/update")
    public JsonResult updateModule(@RequestBody Module module) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(moduleService.updateById(module));
    }

    @GetMapping("/delete")
    public JsonResult deleteModule(Integer id) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(moduleService.removeById(id));
    }
}
