package cn.qg.qaplatform.controller.zdata.yxm;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.mapper.zdata.KdspMapper;
import cn.qg.qaplatform.utils.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping("/kdsp")
public class KdspController {

    @Autowired
    KdspMapper kdspMapper;

    @GetMapping("/sku/list")
    public JsonResult getSkuList(String namespace, Integer skuSource, Double salePriceLimit) {
        SwitchDataSource.dataSourceSwitch(namespace, "kdsp");
        return JsonResult.success(kdspMapper.getSelfSupportSkuNoList(skuSource, salePriceLimit));
    }
}
