package cn.qg.qaplatform.mock.controller;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.mock.entity.Mock;
import cn.qg.qaplatform.mock.service.MockService;
import cn.qg.qaplatform.utils.JsonResult;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@CrossOrigin
@RestController
public class MockController {

    @Autowired
    MockService mockService;

    @RequestMapping(value = "/mock/**", method = { RequestMethod.GET, RequestMethod.POST})
    public void mockMethod() {}

    @PostMapping("/add/mock")
    public JsonResult addMock(@RequestBody Mock mock) {
        SwitchDataSource.dataSourceSwitch("pre", "qa");
        return JsonResult.success(mockService.save(mock));
    }

    @GetMapping("/list/mock")
    public JsonResult getMockList(Integer pageNum, Integer pageSize) {
        SwitchDataSource.dataSourceSwitch("pre", "qa");
        IPage<Mock> page = new Page<>(pageNum, pageSize);
        IPage<Mock> pageEntity = mockService.page(page);
        Map<String, Object> map = new HashMap<>();
        map.put("list", pageEntity.getRecords());
        map.put("total", pageEntity.getTotal());
        return JsonResult.success(map);
    }

    @PostMapping("/edit/mock")
    public JsonResult modifyMock(@RequestBody Mock mock) {
        SwitchDataSource.dataSourceSwitch("pre", "qa");
        return JsonResult.success(mockService.saveOrUpdate(mock));
    }

    @PostMapping(value = "/mock/balance-board/transfer", consumes = "application/xml")
    public String balanceboardTransfer(String requestData) {
        String cmd = requestData.toString().split("<cmd>")[1].split("</cmd>")[0];
        log.info("Mock controller yeepay-transfer cmd-------- {}", cmd);
        String transferResponse = null;
        if("AccountBalanaceQuery".equals(cmd)){
            //查询余额的返回值
            transferResponse = "<data><cmd>AccountBalanaceQuery</cmd><hmac>MIIE6QYJKoZIhvcNAQcCoIIE2jCCBNYCAQExCzAJBgUrDgMCGgUAMC8GCSqGSIb3DQEHAaAiBCAxYTcyYmQwZWVmMWIyNDRkNTFlNmEzYTAwMjk1Mjk1OKCCA7EwggOtMIIDFqADAgECAhAuyfCgPbMcigfvVyGazeQRMA0GCSqGSIb3DQEBBQUAMCQxCzAJBgNVBAYTAkNOMRUwEwYDVQQKEwxDRkNBIFRFU1QgQ0EwHhcNMTExMTI4MDcwOTUzWhcNMTMxMTI4MDcwOTUzWjBzMQswCQYDVQQGEwJDTjEVMBMGA1UEChMMQ0ZDQSBURVNUIENBMQ8wDQYDVQQLEwZZRUVQQVkxEjAQBgNVBAsTCUN1c3RvbWVyczEoMCYGA1UEAxQfMDQxQFoxMjNxd2VAemhpd2VuLm1laUAwMDAwMDAwMTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAzrITNElBaFF7xPXtPguWeTnGOI1gVMMkUDI57ZQz+Gg9PPcfF+ExrtDgMQEOwfRs7X4XiraPE2l6ub0Xkpl0ftu8ELnii91wUKAqsvp88NIdAdLQnC7PeveWlquVSAf//2WtAkdBI7xnhXaL/ObUkhHheT0aR5miYmDyLAkTBj8CAwEAAaOCAY8wggGLMB8GA1UdIwQYMBaAFEZy3CVynwJOVYO1gPkL2+mTs/RFMB0GA1UdDgQWBBS0k6A7ZSwLRwbIhFsgcChrYd27PDALBgNVHQ8EBAMCBaAwDAYDVR0TBAUwAwEBADA7BgNVHSUENDAyBggrBgEFBQcDAQYIKwYBBQUHAwIGCCsGAQUFBwMDBggrBgEFBQcDBAYIKwYBBQUHAwgwgfAGA1UdHwSB6DCB5TBPoE2gS6RJMEcxCzAJBgNVBAYTAkNOMRUwEwYDVQQKEwxDRkNBIFRFU1QgQ0ExDDAKBgNVBAsTA0NSTDETMBEGA1UEAxMKY3JsMTI2XzE5NDCBkaCBjqCBi4aBiGxkYXA6Ly90ZXN0bGRhcC5jZmNhLmNvbS5jbjozODkvQ049Y3JsMTI2XzE5NCxPVT1DUkwsTz1DRkNBIFRFU1QgQ0EsQz1DTj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0P2Jhc2U/b2JqZWN0Y2xhc3M9Y1JMRGlzdHJpYnV0aW9uUG9pbnQwDQYJKoZIhvcNAQEFBQADgYEAKX4CXCPQEE4RWGsZTXZXLBct2gcPYEjqpgPZ5ERiUrYLTDGuIT90ECfSoxCrcTJEeY7EJBojig9gLRoMn/4xXW/XscGarQ3XxyZw8VxTMFkotuUkAPoaacYlIrc34t2DR0DqvU6umgFL3yTMYxl5WLjOh47OH7Aw7VPscmrtzEIxgd0wgdoCAQEwODAkMQswCQYDVQQGEwJDTjEVMBMGA1UEChMMQ0ZDQSBURVNUIENBAhAuyfCgPbMcigfvVyGazeQRMAkGBSsOAwIaBQAwDQYJKoZIhvcNAQEBBQAEgYBW4+qU8lVs4gEk/o+ln33umTlBDViDf+VMA/6vDhfECTy1fbBHqqr84QFBagMqEXGHzXzzP8qGRRAhmKLhn4RimcrvRh3BRbcQig6OEL/Zz1SphFEH0+BRAN+jhLYRt7+zQZvBx65rE52ivMqCpmEQ+6F4BbNCWwJ+0/xbCE4m5Q==</hmac><ret_Code>1</ret_Code><balance_Amount>291227.76</balance_Amount><valid_Amount>291227.76</valid_Amount></data>";
        }else if("TransferBatch".equals(cmd)){
            String batchNo = requestData.toString().split("<batch_No>")[1].split("</batch_No>")[0];
            //申请易宝放款的返回值
            transferResponse = "<?xml version='1.0' encoding='GBK'?><data><cmd>TransferBatch</cmd><hmac>MIIE6QYJKoZIhvcNAQcCoIIE2jCCBNYCAQExCzAJBgUrDgMCGgUAMC8GCSqGSIb3DQEHAaAiBCAyYjM0NGJiNmVlZDliYmY1Mjk3MGNkMGFjMjNlMTA5NqCCA7EwggOtMIIDFqADAgECAhAuyfCgPbMcigfvVyGazeQRMA0GCSqGSIb3DQEBBQUAMCQxCzAJBgNVBAYTAkNOMRUwEwYDVQQKEwxDRkNBIFRFU1QgQ0EwHhcNMTExMTI4MDcwOTUzWhcNMTMxMTI4MDcwOTUzWjBzMQswCQYDVQQGEwJDTjEVMBMGA1UEChMMQ0ZDQSBURVNUIENBMQ8wDQYDVQQLEwZZRUVQQVkxEjAQBgNVBAsTCUN1c3RvbWVyczEoMCYGA1UEAxQfMDQxQFoxMjNxd2VAemhpd2VuLm1laUAwMDAwMDAwMTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAzrITNElBaFF7xPXtPguWeTnGOI1gVMMkUDI57ZQz+Gg9PPcfF+ExrtDgMQEOwfRs7X4XiraPE2l6ub0Xkpl0ftu8ELnii91wUKAqsvp88NIdAdLQnC7PeveWlquVSAf//2WtAkdBI7xnhXaL/ObUkhHheT0aR5miYmDyLAkTBj8CAwEAAaOCAY8wggGLMB8GA1UdIwQYMBaAFEZy3CVynwJOVYO1gPkL2+mTs/RFMB0GA1UdDgQWBBS0k6A7ZSwLRwbIhFsgcChrYd27PDALBgNVHQ8EBAMCBaAwDAYDVR0TBAUwAwEBADA7BgNVHSUENDAyBggrBgEFBQcDAQYIKwYBBQUHAwIGCCsGAQUFBwMDBggrBgEFBQcDBAYIKwYBBQUHAwgwgfAGA1UdHwSB6DCB5TBPoE2gS6RJMEcxCzAJBgNVBAYTAkNOMRUwEwYDVQQKEwxDRkNBIFRFU1QgQ0ExDDAKBgNVBAsTA0NSTDETMBEGA1UEAxMKY3JsMTI2XzE5NDCBkaCBjqCBi4aBiGxkYXA6Ly90ZXN0bGRhcC5jZmNhLmNvbS5jbjozODkvQ049Y3JsMTI2XzE5NCxPVT1DUkwsTz1DRkNBIFRFU1QgQ0EsQz1DTj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0P2Jhc2U/b2JqZWN0Y2xhc3M9Y1JMRGlzdHJpYnV0aW9uUG9pbnQwDQYJKoZIhvcNAQEFBQADgYEAKX4CXCPQEE4RWGsZTXZXLBct2gcPYEjqpgPZ5ERiUrYLTDGuIT90ECfSoxCrcTJEeY7EJBojig9gLRoMn/4xXW/XscGarQ3XxyZw8VxTMFkotuUkAPoaacYlIrc34t2DR0DqvU6umgFL3yTMYxl5WLjOh47OH7Aw7VPscmrtzEIxgd0wgdoCAQEwODAkMQswCQYDVQQGEwJDTjEVMBMGA1UEChMMQ0ZDQSBURVNUIENBAhAuyfCgPbMcigfvVyGazeQRMAkGBSsOAwIaBQAwDQYJKoZIhvcNAQEBBQAEgYAC38fZ2TRB7Myf2VWcQSmGMCO2lGcuAtUfA2m9pHiZ1CZ/cUd/Jj1bmN94QT+7IcPOXw2ZPBbCufeClYHSZRLy3hk3P+WhpGQenlp5zTkJjGvKFKxOdDp6ymlruCE/wQRwH9rMrxhuLkyEauAOQEAeE8EtBsKtBhVanSxEWYlSug==</hmac><ret_Code>1</ret_Code><mer_Id>10000449592</mer_Id><batch_No>" + batchNo + "</batch_No><total_Amt>0.01</total_Amt><total_Num>1</total_Num><r1_Code>0025</r1_Code></data>";
        }else if("BatchDetailQuery".equals(cmd)){
            String batchNo = requestData.toString().split("<batch_No>")[1].split("</batch_No>")[0];
            //放款结果查询的返回值
            transferResponse = "<data><cmd>BatchDetailQuery</cmd><hmac>MIIE6QYJKoZIhvcNAQcCoIIE2jCCBNYCAQExCzAJBgUrDgMCGgUAMC8GCSqGSIb3DQEHAaAiBCA2ZWU1ODE3Y2UwNDg4NDczNmJlNWFlNGM0MDViZGNlYaCCA7EwggOtMIIDFqADAgECAhAuyfCgPbMcigfvVyGazeQRMA0GCSqGSIb3DQEBBQUAMCQxCzAJBgNVBAYTAkNOMRUwEwYDVQQKEwxDRkNBIFRFU1QgQ0EwHhcNMTExMTI4MDcwOTUzWhcNMTMxMTI4MDcwOTUzWjBzMQswCQYDVQQGEwJDTjEVMBMGA1UEChMMQ0ZDQSBURVNUIENBMQ8wDQYDVQQLEwZZRUVQQVkxEjAQBgNVBAsTCUN1c3RvbWVyczEoMCYGA1UEAxQfMDQxQFoxMjNxd2VAemhpd2VuLm1laUAwMDAwMDAwMTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAzrITNElBaFF7xPXtPguWeTnGOI1gVMMkUDI57ZQz+Gg9PPcfF+ExrtDgMQEOwfRs7X4XiraPE2l6ub0Xkpl0ftu8ELnii91wUKAqsvp88NIdAdLQnC7PeveWlquVSAf//2WtAkdBI7xnhXaL/ObUkhHheT0aR5miYmDyLAkTBj8CAwEAAaOCAY8wggGLMB8GA1UdIwQYMBaAFEZy3CVynwJOVYO1gPkL2+mTs/RFMB0GA1UdDgQWBBS0k6A7ZSwLRwbIhFsgcChrYd27PDALBgNVHQ8EBAMCBaAwDAYDVR0TBAUwAwEBADA7BgNVHSUENDAyBggrBgEFBQcDAQYIKwYBBQUHAwIGCCsGAQUFBwMDBggrBgEFBQcDBAYIKwYBBQUHAwgwgfAGA1UdHwSB6DCB5TBPoE2gS6RJMEcxCzAJBgNVBAYTAkNOMRUwEwYDVQQKEwxDRkNBIFRFU1QgQ0ExDDAKBgNVBAsTA0NSTDETMBEGA1UEAxMKY3JsMTI2XzE5NDCBkaCBjqCBi4aBiGxkYXA6Ly90ZXN0bGRhcC5jZmNhLmNvbS5jbjozODkvQ049Y3JsMTI2XzE5NCxPVT1DUkwsTz1DRkNBIFRFU1QgQ0EsQz1DTj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0P2Jhc2U/b2JqZWN0Y2xhc3M9Y1JMRGlzdHJpYnV0aW9uUG9pbnQwDQYJKoZIhvcNAQEFBQADgYEAKX4CXCPQEE4RWGsZTXZXLBct2gcPYEjqpgPZ5ERiUrYLTDGuIT90ECfSoxCrcTJEeY7EJBojig9gLRoMn/4xXW/XscGarQ3XxyZw8VxTMFkotuUkAPoaacYlIrc34t2DR0DqvU6umgFL3yTMYxl5WLjOh47OH7Aw7VPscmrtzEIxgd0wgdoCAQEwODAkMQswCQYDVQQGEwJDTjEVMBMGA1UEChMMQ0ZDQSBURVNUIENBAhAuyfCgPbMcigfvVyGazeQRMAkGBSsOAwIaBQAwDQYJKoZIhvcNAQEBBQAEgYCD/g83n6KyattYAEPqff/9z613+4AaZDHVxY9xEb3lBGRRosVQptgkZItEc9cM2Em/o9GfV/mqj5T6CP5glvbbtFnrz2Z0GGNbDR/gqOIPhpACRZozZipwUeQESVhRCiCJa4sPuoEkgSSq5XvL5nIvAxc59DeKWIv/LGqYq9dK8Q==</hmac><ret_Code>1</ret_Code><batch_No>' + batchNo + '</batch_No><total_Num>1</total_Num><end_Flag>Y</end_Flag><list><items><item><remarksInfo></remarksInfo><amount>0.01</amount><fee></fee><abstractInfo>提现打款</abstractInfo><note/><order_Id>PAYMENT78162155286528</order_Id><payee_Bank_Account>1506213009022200623</payee_Bank_Account><refund_Date></refund_Date><real_pay_amount>0.01</real_pay_amount><payee_BankName>工商银行</payee_BankName><complete_Date>2020-01-16 18:20:09</complete_Date><request_Date>2020-01-16 18:20:08</request_Date><payee_Name>蒋素霞</payee_Name><bank_Status>S</bank_Status><r1_Code>0026</r1_Code><fail_Desc></fail_Desc></item></items></list></data>";
        }
        return transferResponse;
    }
}
