package cn.qg.qaplatform.service.impl;

import cn.qg.qaplatform.common.SwitchDataSource;
import cn.qg.qaplatform.dao.QueryVccDataMapper;
import cn.qg.qaplatform.domain.GenVccUser;
import cn.qg.qaplatform.domain.QueryVccUser;
import cn.qg.qaplatform.process.Vcc;
import cn.qg.qaplatform.service.VccDataService;
import cn.qg.qaplatform.utils.page.PageResult;
import cn.qg.qaplatform.utils.page.PageUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;


@Service
public class VccDataServiceImpl implements VccDataService {

    @Autowired
    QueryVccDataMapper queryVccDataMapper;

    /**
     * vcc造数据
     * @param namespace 环境
     * @param phoneNo 手机号
     * @param openedChannel 创建渠道
     * @param status 0-未激活，1-已激活
     * @return
     * @throws Exception
     */
    @Override
    public GenVccUser makeVccUser(String namespace, String phoneNo, String openedChannel, Integer status) throws Exception {
        GenVccUser genVccUser = new GenVccUser();
        genVccUser.setPhoneNo(phoneNo);
        genVccUser.setOpenedChannel(openedChannel);
        String vccChannel = null;
        if (openedChannel.equals("214")) {
            vccChannel = "159904";
        }
        if (openedChannel.equals("217")) {
            vccChannel = "159905";
        }
        if (vccChannel == null) {
            return null;
        }
        // 登录
        Map loginResult = Vcc.login(namespace, phoneNo, openedChannel, openedChannel);
        String token = loginResult.get("token").toString();
        String uuid = loginResult.get("uuid").toString();
        // 检查用户是否已有额度
        boolean haveQuota = Vcc.checkIfAlreadyHaveQuota(namespace, uuid);
        if (haveQuota) {
            genVccUser.setMsg("用户已有额度！");
            return genVccUser;
        }
        // credit url
        String vccToken = Vcc.creditUrl(namespace, token, vccChannel);
        // 身份证正面
        Vcc.uploadFrontIdCard(vccToken, uuid, vccChannel);
        // 身份证反面
        Vcc.uploadBackIdCard(vccToken, uuid, vccChannel);
        // 放置身份证重复
        Vcc.modifyExistIdNo(namespace);
        // talos保存用户信息
        Vcc.saveUserDetails(namespace, token, vccChannel);
        // 提交ocr
        Vcc.submitOcr(vccToken, vccChannel);
        // 提交授信
        Vcc.submitCredit(namespace, token, vccChannel);
        // 授信结果查询
        Vcc.searchCreditResult(namespace, token, vccChannel);
        if (status == 0) {
            genVccUser.setMsg("提交授信成功！");
            return genVccUser;
        }
        // 人脸识别回调
        Vcc.appFaceCallback(namespace, token, vccChannel);
        // 基本信息
        Vcc.basicInfo(namespace, token, vccChannel);
        // 发送验证码
        String requestId = Vcc.bindCardSms(namespace, token, vccChannel, "ABC", "6228272537046278993");
        // 额度激活
        JSONObject quotaActivationResult = Vcc.quotaActivation(namespace, token, vccChannel, "6228272537046278993", requestId);
        if (status == 1) {
            // 开户结果
            JSONObject result = Vcc.openResult(namespace, token, vccChannel);
            Map data = (Map) result.get("data");
            String amount = data.get("amount").toString();
            String eacctNo = data.get("eacctNo").toString();
            genVccUser.setAmount(amount);
            genVccUser.setEacctNo(eacctNo);
            genVccUser.setMsg("开户成功");
        }
        if (status == 2) {
            Map data = (Map) quotaActivationResult.get("data");
            if (data.get("status").equals("2")) {
                genVccUser.setMsg("开户失败");
            } else {
                genVccUser.setMsg("请找开发手动设置结果为开户失败！");
            }
        }
        return genVccUser;
    }

    /**
     * vcc捞数据
     * @param namespace 环境
     * @param status 状态
     * @return
     */
    @Override
    public PageResult getVccData(String namespace, Integer status, Integer pageNum, Integer pageSize) {
        SwitchDataSource.dataSourceSwitch(namespace, "vcc_talos");
        PageHelper.startPage(pageNum, pageSize);
        List<QueryVccUser> result =  queryVccDataMapper.queryVccDataByStatus(status);
        PageInfo<QueryVccUser> pageList = new PageInfo<>(result);
        PageResult pageResult = PageUtil.getPageResult(pageList, pageNum, pageSize);
        return pageResult;
    }
}
