package cn.qg.qaplatform.controller;

import cn.qg.qaplatform.common.JsonResult;
import cn.qg.qaplatform.service.VccDataService;
import cn.qg.qaplatform.utils.page.PageResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@CrossOrigin
@RestController
@RequestMapping("/vcc")
public class QueryVccController {

    @Autowired
    VccDataService vccDataService;

    @GetMapping("/getData")
    public JsonResult getVccData(@RequestParam(value = "namespace") String namespace,
                                 @RequestParam(value = "status") Integer status,
                                 @RequestParam(defaultValue = "1") Integer pageNum,
                                 @RequestParam(defaultValue = "10") Integer pageSize) {
        PageResult vccData = vccDataService.getVccData(namespace, status, pageNum, pageSize);
        return JsonResult.success(vccData);
    }
}
