package cn.qg.qaplatform.zdata.controller;

import cn.qg.qaplatform.utils.JsonResult;
import cn.qg.qaplatform.zdata.enums.ChannelEnum;
import cn.qg.qaplatform.zdata.enums.FundEnum;
import cn.qg.qaplatform.zdata.entity.ApplyDataVo;
import cn.qg.qaplatform.zdata.entity.GenLoanUser;
import cn.qg.qaplatform.zdata.service.LexinDataService;
import cn.qg.qaplatform.zdata.service.XyqbDataService;
import cn.qg.qaplatform.zdata.service.QueryBasicLoanStatusDataService;
import cn.qg.qaplatform.utils.EnumUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@RestController
@CrossOrigin
@RequestMapping("/gen")
@Api(tags = "造数据相关接口")
public class GenLoanUserDataController {

    @Autowired
    XyqbDataService xyqbDataService;

    @Autowired
    LexinDataService lexinDataService;

    @Autowired
    QueryBasicLoanStatusDataService queryBasicLoanStatusDataService;

    @ApiOperation(value = "造数据接口")
    @PostMapping("/data")
    public JsonResult genLoanUserData(@RequestBody ApplyDataVo applyDataVo) throws Exception {
        boolean result = false;
        if (applyDataVo.getChannel().equals(ChannelEnum.XYQB.getChannelId())) {
            result = xyqbDataService.genLoanUser(applyDataVo);
        }
        if (applyDataVo.getChannel().equals(ChannelEnum.LEXIN.getChannelId())) {
            result = lexinDataService.genLexinData(applyDataVo);
        }
        return JsonResult.success(result);
    }

    @ApiOperation(value = "获取所有支持的资方和渠道")
    @GetMapping("/supportChannelAndFund")
    public JsonResult getSupportedLoanUserData() {
        Map<String, List> map = new HashMap();
        List supportChannel = EnumUtils.enumToListMap(ChannelEnum.class);
        List supportFund = EnumUtils.enumToListMap(FundEnum.class);
        map.put("channelList", supportChannel);
        map.put("fundList", supportFund);
        return JsonResult.success(map);
    }

    @ApiOperation(value = "查询当前用户所处状态")
    @GetMapping("/userStatus")
    public JsonResult queryUserStatus(@RequestParam String namespace,
                                      @RequestParam String phoneNo) {
        GenLoanUser genLoanUser = xyqbDataService.queryUserStatus(namespace, phoneNo);
        return JsonResult.success(genLoanUser);
    }

    @GetMapping("/channelMappedFund")
    public JsonResult mapFund(@RequestParam Integer channel) {
        List<Map<String, Object>> supportFund = EnumUtils.enumToListMap(FundEnum.class);
        List<Map> resultFundList = new LinkedList<>();
        if (channel == 1) {
            for (Map<String, Object> temp: supportFund) {
                if (temp.get("fundId").equals(480) || temp.get("fundId").equals(1030) || temp.get("fundId").equals(1040)) {
                    resultFundList.add(temp);
                }
            }
        }
        if (channel == 159886) {
            for (Map<String, Object> temp: supportFund) {
                if (temp.get("fundId").equals(1010)) {
                    resultFundList.add(temp);
                }
            }
        }
        return JsonResult.success(resultFundList);
    }

    @GetMapping("/fundMappedChannel")
    public JsonResult mapChannel(@RequestParam Integer fundId) {
        List<Map<String, Object>> supportChannel = EnumUtils.enumToListMap(ChannelEnum.class);
        List<Map> resultChannelList = new LinkedList<>();
        if (fundId == 480 || fundId == 1030  || fundId == 1040) {
            for (Map<String, Object> temp: supportChannel) {
                if (temp.get("channelId").equals(1)) {
                    resultChannelList.add(temp);
                }
            }
        }

        if (fundId == 1010) {
            for (Map<String, Object> temp: supportChannel) {
                if (temp.get("channelId").equals(159886)) {
                    resultChannelList.add(temp);
                }
            }
        }
        return JsonResult.success(resultChannelList);
    }

}
