package cn.qg.qaplatform.automation.service.impl;

import cn.qg.qaplatform.automation.domain.Interface;
import cn.qg.qaplatform.automation.mapper.InterfaceMapper;
import cn.qg.qaplatform.automation.service.InterfaceService;
import cn.qg.qaplatform.config.SwitchDataSource;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class InterfaceServiceImpl extends ServiceImpl<InterfaceMapper, Interface> implements InterfaceService {

    @Autowired
    InterfaceMapper interfaceMapper;

    @Override
    public IPage<Interface> getInterfaceList(Integer projectId, Integer moduleId, Integer pageNum, Integer pageSize) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        IPage<Interface> page = new Page<>(pageNum, pageSize);
        return interfaceMapper.getInterfaceList(page, projectId, moduleId);
    }
}
