package cn.qg.qaplatform.service.yxm.impl;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.entity.xyqbuser.User;
import cn.qg.qaplatform.service.xyqbUser.UserService;
import cn.qg.qaplatform.service.yxm.ClearDataService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class ClearDataServiceImpl implements ClearDataService {

    @Autowired
    UserService userService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Override
    public boolean clearData(String namespace, String phoneNo) {
        User user = userService.getUserInfoByPhoneNo(namespace, phoneNo);
        String userId = String.valueOf(user.getId());
        String uuid = user.getUuid();

        log.info("开始删除{}环境{}用户kdsp中的数据！", namespace, phoneNo);
        SwitchDataSource.dataSourceSwitch(namespace, "kdsp");
        List<Map<String, Object>> orderList = jdbcTemplate.queryForList("SELECT * FROM `t_order_info` WHERE user_id = " + userId);
        if (orderList.size() > 0) {
            for (Map<String, Object> map: orderList) {
                String orderNo = map.get("order_no").toString();
                jdbcTemplate.execute(String.format("DELETE FROM `t_order_sku` WHERE order_no = '%s'", orderNo));
                jdbcTemplate.execute(String.format("DELETE FROM `t_order_coupon` WHERE order_no = '%s'", orderNo));
                jdbcTemplate.execute(String.format("DELETE FROM `t_order_refund_apply` WHERE order_no = '%s'", orderNo));
                jdbcTemplate.execute(String.format("DELETE FROM `t_order_refund_proof` WHERE order_no = '%s'", orderNo));
            }
        }
        jdbcTemplate.execute("DELETE FROM `t_user_shop_cart` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_user_receiver_addr` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_user_points_detail` WHERE `user_id` = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_user_points` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_order_info` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_order_sku_coupon` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_order_sku_activity` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_ka_process_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_coupon_user` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `t_comment_info` WHERE user_id = " + userId);

        log.info("开始删除{}环境{}用户vcc_talos中的数据！", namespace, phoneNo);
        SwitchDataSource.dataSourceSwitch(namespace, "vcc_talos");
        jdbcTemplate.execute("DELETE FROM `account` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `risk_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `auth_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `contract_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `credit_trade_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `debit_account` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `debit_record` WHERE user_id = " + userId);
        jdbcTemplate.execute(String.format("DELETE FROM `msg_record` WHERE phone_no = '%s'", phoneNo));
        jdbcTemplate.execute("DELETE FROM `order_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `trade_record` WHERE user_id = " + userId);

        log.info("开始删除{}环境{}用户acsdb中的数据！", namespace, phoneNo);
        SwitchDataSource.dataSourceSwitch(namespace, "acsdb");
        jdbcTemplate.execute("DELETE FROM `acs_account` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_bill` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_cash_account` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_cash_account_record` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_commodity` WHERE user_id = " + userId);
        jdbcTemplate.execute(String.format("DELETE FROM `acs_customer` WHERE uuid = '%s'", uuid));
        jdbcTemplate.execute("DELETE FROM `acs_pay_order` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_payment_order` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `acs_plan` WHERE user_id = " + userId);
        jdbcTemplate.execute(String.format("DELETE FROM `acs_sms` WHERE mobile_no = ''", phoneNo));
        jdbcTemplate.execute("DELETE FROM `acs_trans` WHERE user_id = " + userId);

        log.info("开始删除{}环境{}用户vcc_quota中的数据！", namespace, phoneNo);
        SwitchDataSource.dataSourceSwitch(namespace, "vcc_quota");
        jdbcTemplate.execute("DELETE FROM `user_quota_locker` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `user_quota_log` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `user_quota_record` WHERE user_id = " + userId);

        log.info("开始删除{}环境{}用户xyqb_user中的数据！", namespace, phoneNo);
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb_user");
        jdbcTemplate.execute("DELETE FROM `user` WHERE id = " + userId);
        jdbcTemplate.execute("DELETE FROM `user_detail` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `wechat_userinfo` WHERE user_id = " + userId);
        jdbcTemplate.execute("DELETE FROM `address` WHERE user_id = " + userId);
        return true;
    }
}
