package cn.qg.qaplatform.service.xyqb.impl;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.entity.xyqb.AssignFundingRecord;
import cn.qg.qaplatform.mapper.xyqb.AssignFundingRecordMapper;
import cn.qg.qaplatform.service.xyqb.AssignFundingRecordService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssignFundingRecordServiceImpl extends ServiceImpl<AssignFundingRecordMapper, AssignFundingRecord>
        implements AssignFundingRecordService {

    @Autowired
    AssignFundingRecordMapper assignFundingRecordMapper;

    @Override
    public AssignFundingRecord getFundRecordByUserId(String namespace, String userId) {
        SwitchDataSource.dataSourceSwitch(namespace, "xyqb");
        QueryWrapper<AssignFundingRecord> queryWrapper = new QueryWrapper<>();
        queryWrapper
                .eq("user_id", userId)
                .orderByDesc("id")
                .last("limit 1");
        return assignFundingRecordMapper.selectOne(queryWrapper);
    }
}
