package cn.qg.qaplatform.mock.controller;

import cn.qg.qaplatform.utils.JsonResult;
import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.mock.entity.Mock;
import cn.qg.qaplatform.mock.mapper.MockMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
public class MockController {

    @Autowired
    MockMapper mockMapper;

    @RequestMapping(value = "/mock/**", method = { RequestMethod.GET, RequestMethod.POST})
    public void mockMethod() {}

    @GetMapping("/test")
    public JsonResult test() {
        SwitchDataSource.dataSourceSwitch("pre", "qa");
        QueryWrapper<Mock> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("url", "/pay");
        Mock mock = mockMapper.selectOne(queryWrapper);
        return JsonResult.success(mock);
    }
}
