package cn.qg.qaplatform.mock.encrypt.factory;

import cn.qg.qaplatform.mock.encrypt.paycenter.Aes;
import cn.qg.qaplatform.mock.encrypt.paycenter.Rsa;
import cn.qg.qaplatform.utils.JsonTransUtils;

import java.util.Map;

public class YeebaoEncryptConvertor implements EncryptConvertor {

    private final String privateKey = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBANSBQSc0Hlr+mS7uoIjYS71X2DJ6ZrCcbB1uICqty9QY6W16nZ8tLN/d9k2Z+e2rGG8s7PskpU2T+WuJeDSXs/vpPllG8/tSRVaWcr9EzPaSti3ltSUH0QOLSypZEjTT/slscExj4PMOmQXUXP3gewjNWz1cYRI7dGnKPm+ZFah/AgMBAAECgYB8AcFngz6DkzcI8C+2K6JnJ6/+JPdv8JgWxID45tqfNrphLMB2dwJM0VY+CrCSRNnJZsoT9FqSXtuaKWqAJlbchhPZjupA9RkWFzlGpCQ63/CC71RYYY03eCnc7AIpn52whkjfWG/yf57jKzEwUT+U034uvXdaA+lVvJ0xqpj3gQJBAOmLODjecn450TJbNQaop+7Q5Hz2TUIxbYakzPpcLGv1QYgHa657r7PJ23ZltDBGldMaNTZfqJrtDcq0rTA4lBECQQDo8CcdUhMZ3JbR2UZN0CG8ljMbNWgNWBa37ebE3ZG5yYldc7zY9US/+/7lhxNDqG0saTvM9pJwEc3ccVMvksOPAkEAqq7V+zIQKVJmItBn06MFgNNoei+kTUFEk8f0CvG8gXYwW5NYzp+UzOg1HbW82B9uNmeMBl4pInknwEMF5B0lkQJAdRxQPgCGk+kAdo6LNxHd9Ed7eEF4h8Ty3xQfgnh3DHYTtsU6e8WMBA24kENB3zEtejeKFjkdVHTPD/Z1wSRDZwJAAvNuq0YuRDsESOAerkBZKonA5CD0M4vHTRqihHrjBohv6yxBU8P7gALrX7qmoaZ3aLmN8wHdOAGTR6LZjQdkoQ==";
    private String aesKey = null;
    private String encryptKey = null;

    /**
     * 易宝加密
     * @param response
     * @return
     */
    @Override
    public String encrypt(String response) {
        try {
            Map responseMap = JsonTransUtils.strToMap(response);
            responseMap.put("sign", Rsa.sign(response, privateKey));
            responseMap.put("data", Aes.encryptToBase64(response, aesKey));
            return JsonTransUtils.mapToJson(responseMap);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 易宝解密
     * @param request Http请求的request
     * @return
     */
    @Override
    public String decrypt(String request) {
        try {
            Map requestMap = JsonTransUtils.strToMap(request);
            aesKey = Rsa.decrypt((String) requestMap.get("encryptkey"), privateKey);
            return Aes.decryptFromBase64((String) requestMap.get("data"), aesKey);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
