package cn.qg.qaplatform.mock.interceptor;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.mock.encrypt.factory.EncryptConvertor;
import cn.qg.qaplatform.mock.encrypt.factory.EncryptFactory;
import cn.qg.qaplatform.mock.encrypt.paycenter.Aes;
import cn.qg.qaplatform.mock.encrypt.paycenter.Rsa;
import cn.qg.qaplatform.mock.entity.Mock;
import cn.qg.qaplatform.mock.mapper.MockMapper;
import cn.qg.qaplatform.utils.JsonTransUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

@Slf4j
public class PayInterceptor implements HandlerInterceptor {

    @Autowired
    MockMapper mockMapper;

//    @Value("${namespace}")
    private String namespace = "pre";

    /**
     * 获取HttpServletRequest的body
     * @param request HttpServletRequest
     * @return
     * @throws IOException
     */
    private String getRequestBody(HttpServletRequest request) throws IOException {
        BufferedReader br = request.getReader();
        String str = "";
        String listString = "";
        while ((str = br.readLine()) != null) {
            listString += str;
        }
        return listString;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {
        SwitchDataSource.dataSourceSwitch(namespace, "qa");
        String uri = request.getRequestURI().substring(5);
        Map paramMap = request.getParameterMap();
        log.info("打印请求参数：{}", paramMap.toString());
        QueryWrapper<Mock> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("url", uri);
        Mock mock = mockMapper.selectOne(queryWrapper);
        response.setHeader("Content-type", "application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter printWriter = response.getWriter();
        // 对request进行解密
        EncryptConvertor encryptConvertor = EncryptFactory.produce("yeebao");
        Map<String, Object> requestMap = JsonTransUtils.strToMap(encryptConvertor.decrypt(getRequestBody(request)));
        Map<String, Object> responseMap = new HashMap<>();
        if (uri.equals("/tzt-api/api/bankcard/check")) {
            responseMap.put("bankCode", "ABC");
            responseMap.put("bankName", "中国农业银行");
            responseMap.put("cardTop", "622827");
            responseMap.put("cardlast", "1234");
            responseMap.put("cardtype", "DEBIT");
            responseMap.put("errorcode", "");
            responseMap.put("errormsg", "");
            responseMap.put("isvalid", "VALID");
            responseMap.put("merchantno", "10000449592");
            printWriter.write(encryptConvertor.encrypt(JsonTransUtils.mapToJson(responseMap)));
            return true;
        }
        if (mock.getFlag().equals(1)) {
            responseMap = JsonTransUtils.strToMap(mock.getSuccess());
        } else if (mock.getFlag().equals(0)) {
            responseMap = JsonTransUtils.strToMap(mock.getFail());
        }
        // 如果response中存在变量，则使用requestMap中对应变量进行替换
        for (Map.Entry<String, Object> entry: responseMap.entrySet()) {
            String value = (String) entry.getValue();
            if (value.startsWith("$request")) {
                entry.setValue(requestMap.get(value.split("\\.")[1]));
            }
        }
        // 对response加密
        printWriter.write(encryptConvertor.encrypt(JsonTransUtils.mapToJson(responseMap)));
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                            @Nullable ModelAndView modelAndView) throws Exception {
        // 对请求加密
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler,
                                 @Nullable Exception ex) throws Exception {
        log.info("calling afterCompletion");

    }

    public static void main(String[] args) {
    }
}
