package cn.qg.qaplatform.stools.controller;

import cn.qg.qaplatform.utils.JsonResult;
import cn.qg.qaplatform.stools.utils.kdsp.AESUtil;
import cn.qg.qaplatform.stools.utils.kdsp.RSA;
import cn.qg.qaplatform.stools.vo.EncryptRequest;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.UUID;

@CrossOrigin
@Api(tags = "kdsp加解密接口")
@RestController
@RequestMapping("/kdsp")
public class KdspDecryptController {

    private final String APP_PRIMARY_KEY = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAIZ/jCc0lcdcznjCybFPCGmI9oCnbvMzdCyta7X4Y4ygIOYAQ5vaNiPI2HAEh5X15jR/Cgr4x9YHLBuifKnJezWPmX+ZOYVFDwhlj7FkXS3TVyiuegykomdyg2LCpz06eyLAY+rMiz+ItqUGiemmqFZKfSD328VLaqCvRac5aWotAgMBAAECgYA8E1Kt3F4ee4S6Cf9/FFcklInOc3sqZEw6/IdE85q7oHaxZWLNhY1zNG4AsvVA9WILBsecmPzhy7hW66AVUqqWXA8jLIg/J3UyIRQo1sH9cX+3iERhNZluxXzxcX/UXrVQihyEFWZbehtpXFfPq1F7XzkTKy8qSodRLO79F8Tc/QJBAOF2vZ4Ah8GhiZP/KMYX7Q1fY5x/zTKmnNs1fJGDoRmgcF47Inzf2Ovjo+do/QdCf+Bzki6WG0AOpIHKksuw5r8CQQCYtttPfP8FKRxumcczNmkaKDWjrKElwRcGef5OuNBb7Crso9gUY+sL9/4kQHfmBfCS6KVbAA56RSdeSWFYZDYTAkA58pbRoTlDHw2JKC+Gmmem5Dlp478NoZz3Ckw16irht0aqMXCvv6i1GBDsTSObVhAf1BRiPNpMIHdPlI0eJR1pAkA7Oge6P0cEcFpHhrpb4UlHzLpo3QWuh8FvUJbRXxnn3KMVHcIqvkmlXauh0aLugfU4dKPUtCPpRbKr/ZeUWWEjAkAN5D5hH16RwrR6KN8W7t0gnlwOECPD8KbBQeWSja9r8C/yWMmr4RsWirBoDSYu4IG8jnrNcmYk8l1eAWmNyJWe";

    @ApiOperation(value = "kdsp提交订单解密接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "data", value = "待解密的json串", required = true)})
    @GetMapping("/decrypt")
    public JsonResult decryptKdsp(String data) throws Exception {
        EncryptRequest encryptRequest = JSON.parseObject(data, EncryptRequest.class);
        //使用服务端私钥对AES key进行解密
        String encryptKey = RSA.decryptFromBase64(encryptRequest.getEncryptKey(), APP_PRIMARY_KEY);
        String result = AESUtil.decryptFromBase64(encryptRequest.getBody(), encryptKey);
        return JsonResult.success(result);
    }

    @ApiOperation(value = "kdsp提交订单加密接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "data", value = "待加密的json串", required = true)})
    @GetMapping("/encrypt")
    public JsonResult encryptKdsp(String data) throws Exception {
        EncryptRequest encryptRequest = new EncryptRequest();
        //加密过程
        String appId = "102";
        String SERVER_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCGf4wnNJXHXM54wsmxTwhpiPaAp27zM3QsrWu1+GOMoCDmAEOb2jYjyNhwBIeV9eY0fwoK+MfWBywbonypyXs1j5l/mTmFRQ8IZY+xZF0t01cornoMpKJncoNiwqc9OnsiwGPqzIs/iLalBonppqhWSn0g99vFS2qgr0WnOWlqLQIDAQAB";
        String nonce = UUID.randomUUID().toString();
        String timeStamp = DateFormatUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss");
        //生成AES key
        String randomKey = AESUtil.getRandomKey();
        //使用AES key对业务数据进行加密
        String encodeBody = AESUtil.encryptToBase64(data, randomKey);
        String body = appId + nonce + timeStamp + encodeBody;
        //使用私钥进行签名
        String sign = RSA.sign(body, APP_PRIMARY_KEY);
        //使用服务端公钥对AES key进行加密
        String encryptKey = RSA.encryptToBase64(randomKey, SERVER_PUBLIC_KEY);

        encryptRequest.setAppId(appId);
        encryptRequest.setEncryptKey(encryptKey);
        encryptRequest.setBody(encodeBody);
        encryptRequest.setSign(sign);
        encryptRequest.setNonce(nonce);
        encryptRequest.setTimestamp(timeStamp);
        return JsonResult.success(JSON.toJSONString(encryptRequest));
    }

}
