package cn.qg.qaplatform.automation.controller;

import cn.qg.qaplatform.automation.domain.Testcase;
import cn.qg.qaplatform.automation.service.AssertService;
import cn.qg.qaplatform.automation.service.TestcaseService;
import cn.qg.qaplatform.common.JsonResult;
import cn.qg.qaplatform.common.SwitchDataSource;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/testcase")
public class TestcaseController {

    @Autowired
    TestcaseService testcaseService;

    @Autowired
    AssertService assertService;

    @GetMapping("/list")
    public JsonResult getTestcaseList(Integer projectId, Integer moduleId,
                                      @RequestParam(defaultValue = "1") Integer pageNum,
                                      @RequestParam(defaultValue = "10") Integer pageSize) {
        IPage<Testcase> pageEntity = testcaseService.getTestcaseList(projectId, moduleId, pageNum, pageSize);
        Map<String, Object> map = new HashMap<>();
        map.put("list", pageEntity.getRecords());
        map.put("total", pageEntity.getTotal());
        return JsonResult.success(map);
    }

    @GetMapping("/type")
    public JsonResult getTestcaseTypes() {
        Map<String, String> map = new HashMap<>();
        map.put("0", "标准用例");
        map.put("1", "正常用例");
        map.put("2", "异常用例");
        return JsonResult.success(map);
    }

    @PostMapping("/add")
    public JsonResult addTestcase(@RequestBody Testcase testcase) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(testcaseService.save(testcase));
    }

    @GetMapping("/execute")
    public JsonResult executeTestcase(Integer testcaseId) throws Exception {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        Map<String, Object> resultMap = new HashMap<>();
        JSONObject response =  testcaseService.exexuteTestcase(testcaseId);
        Boolean assertResult = assertService.assertResponse(testcaseId, response);
        resultMap.put("response", response);
        resultMap.put("assertResult", assertResult);
        if (response != null && assertResult) {
            return JsonResult.success(resultMap);
        } else {
            return JsonResult.serverFailed(resultMap);
        }
    }

    @PostMapping("/update")
    public JsonResult updateTestcase(@RequestBody Testcase testcase) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        Boolean updateResult = testcaseService.updateById(testcase);
        return JsonResult.success(updateResult);
    }

    @GetMapping("/delete")
    public JsonResult deleteTestcase(Integer id) {
        SwitchDataSource.dataSourceSwitch("localhost", "automation");
        return JsonResult.success(testcaseService.removeById(id));
    }
}
