package cn.qg.qaplatform.automation.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 用例实体类
 */
@Data
public class Testcase {
    @TableId(type = IdType.AUTO)
    private Integer id;

    private Integer interfaceId;

    private String name;

    @TableField(value = "type")
    private Integer type;

    private String headers;

    @TableField(value = "params")
    private String params;

    private String author;

    private Integer projectId;

    private Integer moduleId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mmLss")
    private Date updateTime;

    @TableField(exist = false)
    private String projectName;

    @TableField(exist = false)
    private String moduleName;
}
