package cn.qg.qaplatform.mock.interceptor;

import cn.qg.qaplatform.config.SwitchDataSource;
import cn.qg.qaplatform.mock.entity.Mock;
import cn.qg.qaplatform.mock.mapper.MockMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

@Slf4j
public class PayInterceptor implements HandlerInterceptor {

    @Autowired
    MockMapper mockMapper;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {
        SwitchDataSource.dataSourceSwitch("pre", "qa");
        String uri = request.getRequestURI().substring(5);
        QueryWrapper<Mock> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("url", uri);
        Mock mock = mockMapper.selectOne(queryWrapper);
        response.setHeader("Content-type", "application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter printWriter = response.getWriter();
        if (mock.getFlag().equals(1)) {
            printWriter.write(mock.getSuccess());
        } else if (mock.getFlag().equals(0)) {
            printWriter.write(mock.getFail());
        }
        // 对请求进行解密TF
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                            @Nullable ModelAndView modelAndView) throws Exception {
        // 对请求加密
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler,
                                 @Nullable Exception ex) throws Exception {
        log.info("calling afterCompletion");

    }
}
