package cn.qg.qaplatform.process;

import cn.qg.qaplatform.encrypt.kdsp.AESUtil;
import cn.qg.qaplatform.encrypt.kdsp.RSA;
import cn.qg.qaplatform.utils.HttpClientUtils;
import cn.qg.qaplatform.vo.EncryptRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jayway.jsonpath.JsonPath;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.net.URISyntaxException;
import java.util.*;

/**
 * 电商购买类
 * @author libo
 */
@Slf4j
public class Purchase {

    /**
     * 登录
     * @param namespace 环境
     * @param phoneNo 手机号
     * @param deviceId 设备id
     * @return
     */
    public static String loginApp(String namespace, String phoneNo, String deviceId) {
        String url = "http://sappbackend-" + namespace + ".liangkebang.net/auth/fast-login";
        Map<String, Object> headers = new HashMap<>();
        Map<String, Object> params = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("version", "7.9.00");
        headers.put("channel", 214);
        headers.put("appName", "xinyongqianbao");
        headers.put("idfa", "D69C97EC-AC7F-4C5D-AC14-50933E990795");
        headers.put("device_id", deviceId);
        params.put("createdFrom", 214);
        params.put("username", phoneNo);
        params.put("vcode", "000000");
        JSONObject response = HttpClientUtils.doPost(url, params, headers);
        log.info("登录App：{}", response);
        return JsonPath.read(response, "$.token");
    }

    /**
     * 获取地址列表
     * @param namespace 环境
     * @param token 登录token
     * @return
     * @throws URISyntaxException
     */
    public static Integer getAddressList(String namespace, String token) throws URISyntaxException {
        String url = "http://talos-" + namespace + ".liangkebang.net/api/kdsp/addr/receiver/list";
        Map<String, Object> headers = new HashMap<>();
        headers.put("x-auth-token", token);
        JSONObject response = HttpClientUtils.doGetReturnJson(url, null, headers);
        log.info("获取地址列表响应：" + response);
        List<Map<String, Object>> addressIdList = JsonPath.read(response, "$.data.addrReceiverList[*].addrReceiverId");
        if (addressIdList.size() == 0) {
            return addAddress(namespace, token);
        }
        return JsonPath.read(response, "$.data.addrReceiverList[0].addrReceiverId");
    }

    public static Integer addAddress(String namespace, String token) {
        String url = "http://talos-" + namespace + ".liangkebang.net/api/kdsp/addr/receiver/add_edit";
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/json");
        headers.put("x-auth-token", token);
        headers.put("x-user-terminal", "IOS");
        Map<String, Object> params = new HashMap<>();
        params.put("cityId", "2800");
        params.put("provinceId", "1");
        params.put("countyId", "55816");
        params.put("townId", "");
        params.put("detail", "中国电子大厦B座");
        params.put("receiverName", "量化派");
        params.put("receiverPhoneNo", "18311069063");
        params.put("addrDefault", "1");
        JSONObject response = HttpClientUtils.doPostJson(url, JSON.toJSONString(params), headers);
        return JsonPath.read(response, "$.data.addrReceiverId");
    }

    /**
     * 确认订单
     * @param namespace 环境
     * @param token 用户token
     * @param skuNo sku no
     * @param addrReceiverId 地址id
     * @param deviceId 设备id
     * @return
     */
    public static Map<String, Object> confirmOrder(String namespace, String token, String skuNo, Integer addrReceiverId, String deviceId) {
        String url = "http://talos-" + namespace + ".liangkebang.net/api/kdsp/shop-cart/order-confirm/page/v2";
        Map<String, Object> headers = new HashMap<>();
        Map<String, Object> params = new HashMap<>();
        headers.put("Content-Type", "application/json");
        headers.put("x-auth-token", token);
        headers.put("x-user-terminal", "IOS");
        List<Map<String, Object>> skuList = new ArrayList<>();
        List<String> couponActivityUseIdList = new ArrayList<>();
        Map<String, Object> skuMap = new HashMap<>();
        skuMap.put("skuNum", 1);
        skuMap.put("skuSource", 1);
        skuMap.put("skuId", skuNo);
        skuList.add(skuMap);
        params.put("selectedSkuList", skuList);
        params.put("defaultUseCashCoupon", true);
        params.put("defaultUseFreightFeeCoupon", true);
        params.put("couponActivityUseIdList", couponActivityUseIdList);
        params.put("defaultUseActivityCoupon", true);
        params.put("defaultUseCoupon", true);
        params.put("addrReceiverId", addrReceiverId);
        JSONObject response = HttpClientUtils.doPostJson(url, JSON.toJSONString(params), headers);
        log.info("确认订单返回结果：" + response);
        Map<String, Object> result = new HashMap<>();
        result.put("totalFreightFee", JsonPath.read(response, "$.data.calcFeeInfo.totalFreightFee").toString());
        result.put("totalFee", JsonPath.read(response, "$.data.calcFeeInfo.totalPayFee").toString());
        result.put("receiverId", addrReceiverId);
        List<Map<String, Object>> resultSkuList = new ArrayList<>();
        Map<String, Object> skuMap2 = new HashMap<>();
        skuMap2.put("skuNo", skuNo);
        skuMap2.put("count", 1);
        resultSkuList.add(skuMap2);
        result.put("skuList", resultSkuList);
        return result;
    }

    /**
     * 提交订单
     * @param namespace 环境
     * @param token token
     * @param params 请求参数
     * @return
     * @throws Exception
     */
    public static String submitOrder(String namespace, String token, Map<String, Object> params) throws Exception {
        System.out.println("提交订单参数：" + JSON.toJSONString(params));
        String url = "http://talos-" + namespace + ".liangkebang.net/api/kdsp/order-info/e/submit";
//        String url = "http://192.168.28.41/api/kdsp/order-info/e/submit";
        EncryptRequest encryptRequest = new EncryptRequest();
        //加密过程
        String appId = "101";
//        String APP_PRIMARY_KEY = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAIZ/jCc0lcdcznjCybFPCGmI9oCnbvMzdCyta7X4Y4ygIOYAQ5vaNiPI2HAEh5X15jR/Cgr4x9YHLBuifKnJezWPmX+ZOYVFDwhlj7FkXS3TVyiuegykomdyg2LCpz06eyLAY+rMiz+ItqUGiemmqFZKfSD328VLaqCvRac5aWotAgMBAAECgYA8E1Kt3F4ee4S6Cf9/FFcklInOc3sqZEw6/IdE85q7oHaxZWLNhY1zNG4AsvVA9WILBsecmPzhy7hW66AVUqqWXA8jLIg/J3UyIRQo1sH9cX+3iERhNZluxXzxcX/UXrVQihyEFWZbehtpXFfPq1F7XzkTKy8qSodRLO79F8Tc/QJBAOF2vZ4Ah8GhiZP/KMYX7Q1fY5x/zTKmnNs1fJGDoRmgcF47Inzf2Ovjo+do/QdCf+Bzki6WG0AOpIHKksuw5r8CQQCYtttPfP8FKRxumcczNmkaKDWjrKElwRcGef5OuNBb7Crso9gUY+sL9/4kQHfmBfCS6KVbAA56RSdeSWFYZDYTAkA58pbRoTlDHw2JKC+Gmmem5Dlp478NoZz3Ckw16irht0aqMXCvv6i1GBDsTSObVhAf1BRiPNpMIHdPlI0eJR1pAkA7Oge6P0cEcFpHhrpb4UlHzLpo3QWuh8FvUJbRXxnn3KMVHcIqvkmlXauh0aLugfU4dKPUtCPpRbKr/ZeUWWEjAkAN5D5hH16RwrR6KN8W7t0gnlwOECPD8KbBQeWSja9r8C/yWMmr4RsWirBoDSYu4IG8jnrNcmYk8l1eAWmNyJWe";
        String APP_PRIMARY_KEY = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAINPX+KdtJJYHHgLrurdJOK4mAGeP/RST69ATX1Ir4YBasxmIL7XMRtgJHjwrUZv7v3c4M/RQSSwUXQP5NLE7ns4uZUm/JZoG1zgmq43IqyuwTLlitwYn221DWToehmKp9uC1WhK84EfkCDtinqLA7Rslh9FrlKkVHyus2eONPm7AgMBAAECgYB43wzthqwcdj0mh+Ko0Y5NoQxTmP9YAJjXQoLSC6F+4jkUFAKaiW3rvDF2nl1yVEETsEnFIuMrSZ6BDsxc8+htb458A/kMXdyNvE1eaSnYd5Y0kPX+IyaX6+fTHfGF7SvEs4gHKJFW+G1UQ0veDTeUlNGQVwj5eVnAj+UhWuKWSQJBAN0SFsi/jnc5moqH7F/SNUKNtSCOhRaz/RjEdTjHHWpCYmK8RP+cfHJp4Cb7P/jG0XEFFQSS5FIjQn6ujAfiSH8CQQCYDqFjWxhViONtjnuovqBIKGxppk5SA22leSa53Bads26HKpsIHsFQvr3fXMe2BEUsGFYN20mlouQP7BHn1NDFAkBpJ0KJKHyWf2LgA/lONsm4p3kBTGlHvENmNYRghm2abosn1c+oGgIj1fKV+Cqcpc1XyggOTeSmoTju0w2ublb3AkAOt4PJQPzW8nvIk7zGNUUAFuF/TDhSWcCX/mTQIkwSEVbGQEpm+8sMDJoF703pAPrM7MIPb0Tughh+rgOBo6hdAkEAz7Q1UnZSwr2+2sgKUnMxUVCPTt/ImyWXukU8Uys8hT3i8XFex7dTaAd8XG3Zc77amaXvIBqxo5I6jKbzJCZUwA==";
        String SERVER_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCGf4wnNJXHXM54wsmxTwhpiPaAp27zM3QsrWu1+GOMoCDmAEOb2jYjyNhwBIeV9eY0fwoK+MfWBywbonypyXs1j5l/mTmFRQ8IZY+xZF0t01cornoMpKJncoNiwqc9OnsiwGPqzIs/iLalBonppqhWSn0g99vFS2qgr0WnOWlqLQIDAQAB";
        String nonce = UUID.randomUUID().toString();
        String timeStamp = DateFormatUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss");
        //生成AES key
        String randomKey = AESUtil.getRandomKey();
        //使用AES key对业务数据进行加密
        String encodeBody = AESUtil.encryptToBase64(JSON.toJSONString(params), randomKey);
        String body = appId + nonce + timeStamp + encodeBody;
        //使用私钥进行签名
        String sign = RSA.sign(body, APP_PRIMARY_KEY);
        //使用服务端公钥对AES key进行加密
        String encryptKey = RSA.encryptToBase64(randomKey, SERVER_PUBLIC_KEY);

        encryptRequest.setAppId(appId);
        encryptRequest.setEncryptKey(encryptKey);
        encryptRequest.setBody(encodeBody);
        encryptRequest.setSign(sign);
        encryptRequest.setNonce(nonce);
        encryptRequest.setTimestamp(timeStamp);

        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/json");
        headers.put("x-user-terminal", "IOS");
        headers.put("x-auth-token", token);
        headers.put("scDeviceId", "D69C97EC-AC7F-4C5D-AC14-50933E990795");
        headers.put("vccChannel", 214);
        headers.put("version", "7.9.00");
        headers.put("appName", "xinyongqianbao");

        JSONObject response = HttpClientUtils.doPostJson(url, JSON.toJSONString(encryptRequest), headers);
        log.info("加密结果： " + JSON.toJSONString(encryptRequest));
        log.info("提交订单返回结果：" + response);
        return null;
    }

    public static void main(String[] args) throws Exception {
        String namespace = "vcc2";
        String token = loginApp(namespace, "18300002000", "D69C97EC-AC7F-4C5D-AC14-50933E990795");
        Integer addressId = getAddressList(namespace, token);
        Map<String, Object> submitParams = confirmOrder(namespace, token, "26423184333313", addressId, "D69C97EC-AC7F-4C5D-AC14-50933E990795");
        submitOrder(namespace, token, submitParams);
    }

}
