package cn.qg.qaplatform.entity.kdsp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * sku基本信息表
 */
@Data
@TableName(value = "t_sku_info")
public class TSkuInfo {

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * sku编号
     */
    private String skuNo;

    /**
     * 三方唯一编号
     */
    private String uniqueNo;

    /**
     * spu编号
     */
    private String spuNo;

    /**
     * 第三方sku编码
     */
    private String thirdSkuNo;

    /**
     * 第三方spu编码
     */
    private String thirdSpuNo;

    /**
     * 商品名称
     */
    private String skuName;

    /**
     * 商品主图
     */
    private String imageUrl;

    /**
     * 商品缩略图
     */
    private String thumbnailUrl;

    /**
     * 分享图
     */
    private String shareUrl;

    /**
     * 商品来源 1-自营 2-京东开普勒 3-京东联盟 4-众联 5-企业购 6-企业购直连
     */
    private Integer skuSource;

    /**
     * 商品类型 1:普通商品 2;虚拟商品 3:电子卡卷
     */
    private Integer productType;

    /**
     * 成本价格
     */
    private BigDecimal costPrice;

    /**
     * 市场价格
     */
    private BigDecimal marketPrice;

    /**
     * 供应链市场价格
     */
    private BigDecimal scMarketPrice;

    /**
     * 销售价格
     */
    private BigDecimal salePrice;

    /**
     * 库存
     */
    private Integer stock;

    /**
     * 销售数量
     */
    private Integer saleCount;

    /**
     * 前端显示销售数量
     */
    private Integer showSaleCount;

    /**
     * 限制购买数量
     */
    private Integer limitCount;

    /**
     * 商家名称
     */
    private String venderName;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 店铺id
     */
    private Long shopId;

    /**
     * 品牌id
     */
    private Long brandId;

    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 商品产地
     */
    private String placeOfProduction;

    /**
     * 商品型号
     */
    private String productModel;

    /**
     * 商品颜色
     */
    private String productColor;

    /**
     * 商品排序
     */
    private Integer rank;

    /**
     * 后端一级类目id
     */
    private Long cId1;

    /**
     * 后端二级类目id
     */
    private Long cId2;

    /**
     * 后端三级类目id
     */
    private Long cId3;

    /**
     * 发布时间
     */
    private String pushedAt;

    /**
     * 下架时间
     */
    private String offlineAt;

    /**
     * 商品状态	1-未上架 2-审核中 3-已上架 4-我方下架 5-三方下架
     */
    private Integer status;

    private String detailContentUrl;

    /**
     *  审核状态 0：待审核，1：审核中，2:审核拒绝，3：审核完成
     */
    private Integer auditStatus;

    /**
     * 无理由退货类型 0-不支持无理由退货 1-支持7天无理由退货 2-支持15天无理由退货 3-支持30天无理由退货 4-支持60天无理由退货 5-支持90天无理由退货
     */
    private Integer returnType;

    /**
     * 是否厂直商品 0-否 1-是
     */
    private Integer isFactoryShip;

    /**
     * 0-无效 1-有效
     */
    private Integer enable;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 更新时间
     */
    private Date updatedAt;

    /**
     * 京东拉取价格的商品编号
     */
    private String pullPriceSkuNo;
}
