import request from '@/utils/holmesRequest'
// 项目模块相关接口
export function getProjectList(queryInfo) {
  return request({
    url: '/auto/project/list',
    method: 'get',
    params: queryInfo
  })
}
export function addProject(data) {
  return request({
    url: '/auto/project/add',
    method: 'post',
    data
  })
}
export function editProject(data) {
  return request({
    url: '/auto/project/modify',
    method: 'post',
    data
  })
}
export function delProject(queryInfo) {
  return request({
    url: '/auto/project/delete',
    method: 'get',
    params: queryInfo
  })
}
// 模块列表相关接口
export function getModulList(queryInfo) {
  return request({
    url: '/auto/module/list',
    method: 'get',
    params: queryInfo
  })
}
// 添加模块接口
export function addModul(data) {
  return request({
    url: '/auto/module/add',
    method: 'post',
    data
  })
}
// 编辑模块接口
export function editModel(data) {
  return request({
    url: '/auto/module/modify',
    method: 'post',
    data
  })
}
// 删除模块
export function delModel(queryInfo) {
  return request({
    url: '/auto/module/delete',
    method: 'get',
    params: queryInfo
  })
}
// 获取接口列表
export function interfaceDetailList(queryInfo) {
  return request({
    url: '/auto/interface/list',
    method: 'get',
    params: queryInfo
  })
}
// 添加接的口接口
export function addInterface(data) {
  return request({
    url: '/auto/interface/add',
    method: 'post',
    data
  })
}
// 编辑接口的接口
export function editInterface(data) {
  return request({
    url: '/auto/interface/modify',
    method: 'post',
    data
  })
}
// 删除接口的接口
export function delInterface(queryInfo) {
  return request({
    url: '/auto/interface/delete',
    method: 'get',
    params: queryInfo
  })
}
// 获取某个接口下的所有用例
export function getCaseByInterface(queryInfo) {
  return request({
    url: '/auto/testcase/byInterface',
    method: 'get',
    params: queryInfo
  })
}
// 根据URL获取headers和请求参数
export function getInterfaceUrl(queryInfo) {
  return request({
    url: '/auto/interface/curl',
    method: 'get',
    params: queryInfo
  })
}
