import Vue from 'vue'
import Router from 'vue-router'
import Index from '../views/index/Index'
// import Login from '../views/login/Login'
import Main from '../views/Main'
// import Home from '../views/Home'
import Home from '../views/layout/Home'
import XyqbGenLoanData from '../views/xyqb/GenLoanData'
import XyqbGetLoanData from '../views/xyqb/GetLoanData'
import VccGetData from '../views/vcc/GetData'
import VccGenData from '../views/vcc/GenData'
import VccCheckData from '../views/vcc/CheckData'
import Mock from '../views/mock/Mock'
import kdspDecrypt from '../views/effect/KdspDecrypt'
import JenkinsBuildInfo from '../views/effect/JenkinsBuildInfo'
import LoginWhiteList from '../views/effect/LoginWhiteList'
// 2021-040-09新添加
import ProjectList from '../views/auto/Project'
import ModelList from '../views/auto/Model'
import InterfaceList from '../views/auto/InterfaceList'
import JiraNotify from '../views/jira/Notify'
import RiskControl from '../views/vcc/RiskControl'
import ClearCache from '../views/effect/ClearCache'
import ClearData from '../views/effect/ClearData'
import AddInterface from '../views/auto/AddInterface'
import CaseList from '../views/auto/CaseList'
import AddCase from '../views/auto/AddCase'
import SceneList from '../views/auto/SceneList'
import EditScene from '../views/auto/EditScene'

Vue.use(Router)
const router = new Router({
  mode: 'history',
  routes: [
    {
      path: '/',
      redirect: '/index'
    },
    {
      path: '/index',
      name: '登录页',
      component: Index
    },
    // {
    //   'path': '/login',
    //   component: Login
    // },
    {
      'path': '/home',
      'redirect': '/main',
      component: Home,
      children: [
        {
          path: '/main',
          name: '主页',
          component: Main
        },
        {
          path: '/xyqb/genLoanData',
          name: '捞数据',
          component: XyqbGenLoanData
        },
        {
          path: '/xyqb/getLoanData',
          name: '造数据',
          component: XyqbGetLoanData
        },
        {
          path: '/vcc/getData',
          name: '查数据',
          component: VccGetData
        },
        {
          path: '/vcc/genData',
          name: 'VCC捞数据',
          component: VccGenData
        },
        {
          path: '/vcc/checkData',
          name: '造数据',
          component: VccCheckData
        },
        {
          path: '/mock/list',
          name: '工具',
          component: Mock
        },
        {
          path: '/effect/kdsp/decrypt',
          name: 'kdsp解密',
          component: kdspDecrypt
        },
        {
          path: '/effect/jenkins/build',
          name: '构建记录',
          component: JenkinsBuildInfo
        },
        {
          path: '/effect/whitelist',
          name: '登录白名单',
          component: LoginWhiteList
        },
        // 2021-4-08新添加项目管理页面
        {
          path: '/auto/Project',
          name: ProjectList,
          component: ProjectList
        },
        {
          path: '/auto/Model',
          name: ModelList,
          component: ModelList
        },
        {
          path: '/auto/InterfaceList',
          name: InterfaceList,
          component: InterfaceList
        },
        {
          path: '/auto/AddInterface',
          name: AddInterface,
          component: AddInterface
        },
        {
          path: '/auto/CaseList',
          name: CaseList,
          component: CaseList
        },
        {
          path: '/auto/AddCase',
          name: AddCase,
          component: AddCase
        },
        {
          path: '/auto/SceneList',
          name: SceneList,
          component: SceneList
        },
        // 编辑场景
        {
          path: '/auto/EditScene',
          name: EditScene,
          component: EditScene
        },
        {
          'path': '/jira/notify',
          component: JiraNotify
        },
        {
          'path': '/vcc/risk',
          component: RiskControl
        },
        {
          'path': '/effect/clearcache',
          component: ClearCache
        },
        {
          'path': '/effect/cleardata',
          component: ClearData
        }
      ]
    }

  ]
})
export default router
