import Vue from 'vue'
import Router from 'vue-router'
import Index from '../views/Index/Index'
import Login from '../views/Login/Login'
import Main from '../views/Main'
import Home from '../views/Home'
import Project from '../views/Automation/Project'
import Case from '../views/Automation/Case'
import Report from '../views/Automation/Report'
import XyqbGenLoanData from '../views/Xyqb/GenLoanData'
import XyqbGetLoanData from '../views/Xyqb/GetLoanData'
import VccGetData from '../views/Vcc/GetData'
import VccGenData from '../views/Vcc/GenData'

Vue.use(Router)

const router = new Router({
  mode: 'history',
  routes: [
    {
      'path': '/',
      redirect: '/index'
    },
    {
      'path': '/index',
      component: Index
    },
    {
      'path': '/login',
      component: Login
    },
    {
      'path': '/home',
      component: Home,
      children: [
        {
          'path': '/main',
          component: Main
        },
        {
          'path': '/project',
          component: Project
        },
        {
          'path': '/case',
          component: Case
        },
        {
          'path': '/report',
          component: Report
        },
        {
          'path': '/xyqb/genLoanData',
          component: XyqbGenLoanData
        },
        {
          'path': '/xyqb/getLoanData',
          component: XyqbGetLoanData
        },
        {
          'path': '/vcc/getData',
          component: VccGetData
        },
        {
          'path': '/vcc/genData',
          component: VccGenData
        }
      ]
    }
  ]
})

export default router
