import request from '@/utils/holmesRequest'
// 获取case列表
export function singleCaseList(queryInfo) {
  return request({
    url: '/auto/testcase/list',
    method: 'get',
    params: queryInfo
  })
}
// 获取接口详情
export function getInterfaceDetail(queryInfo) {
  return request({
    url: '/auto/interface/detail',
    method: 'get',
    params: queryInfo
  })
}
// 添加用例接口
export function addCase(data) {
  return request({
    url: '/auto/testcase/add',
    method: 'post',
    data
  })
}
// 删除case接口
export function delCase(queryInfo) {
  return request({
    url: '/auto/testcase/delete',
    method: 'get',
    params: queryInfo
  })
}
// 执行单个case
export function executeCase(queryInfo) {
  return request({
    url: '/auto/execute/testcase',
    method: 'get',
    params: queryInfo
  })
}
// 单个用例编辑接口
export function editCase(data) {
  return request({
    url: '/auto/testcase/modify',
    method: 'post',
    data
  })
}
