import Vue from 'vue'
import Router from 'vue-router'
import Login from '../components/Login'
import Home from '../components/Home'
import Project from '../components/Automation/Project'
import Case from '../components/Automation/Case'
import Report from '../components/Automation/Report'
import GenNewLoanData from '../components/Data/GenNewLoanData'
import CheckOldLoanData from '../components/Data/CheckOldLoanData'

Vue.use(Router)

const router = new Router({
  mode: 'history',
  routes: [
    {
      'path': '/',
      redirect: '/home'
    },
    {
      'path': '/login',
      component: Login
    },
    {
      'path': '/home',
      component: Home,
      children: [
        {
          'path': '/project',
          component: Project
        },
        {
          'path': '/case',
          component: Case
        },
        {
          'path': '/report',
          component: Report
        },
        {
          'path': '/genNewLoanData',
          component: GenNewLoanData
        },
        {
          'path': '/checkOldLoanData',
          component: CheckOldLoanData
        }
      ]
    }
  ]
})

export default router
