import request from '@/utils/holmesRequest'
export function getSceneList(queryInfo) {
  return request({
    url: '/auto/scene/list',
    method: 'get',
    params: queryInfo
  })
}
// 添加场景接口
export function addSecene(data) {
  return request({
    url: '/auto/scene/add',
    method: 'post',
    data
  })
}
// 删除场景
export function delSecne(queryInfo) {
  return request({
    url: '/auto/scene/delete',
    method: 'get',
    params: queryInfo
  })
}
// 获取场景用例列表接口
export function getSceneCaseList(queryInfo) {
  return request({
    url: '/auto/sceneTestcase/list',
    method: 'get',
    params: queryInfo
  })
}
// 添加场景用例接口
export function addSceneCase(data) {
  return request({
    url: '/auto/sceneTestcase/saveOrUpdate',
    method: 'post',
    data
  })
}
// 执行场景用例接口
export function executeScene(queryInfo) {
  return request({
    url: '/auto/execute/scene',
    method: 'get',
    params: queryInfo
  })
}
// 编辑场景接口
export function editScene(data) {
  return request({
    url: '/auto/scene/modify',
    method: 'post',
    data
  })
}
