import request from '@/utils/holmesRequest'
// 获取用户列表
export function getUserList(paramInfo) {
  return request({
    url: '/user/list',
    method: 'get',
    params: paramInfo
  })
}
// 获取角色列表
export function getRoleList(paramInfo) {
  return request({
    url: '/role/list',
    method: 'get',
    params: paramInfo
  })
}
// 编辑用户角色信息
export function saveUserForm(data) {
  return request({
    url: '/user/role/edit',
    method: 'post',
    data
  })
}
// 获取权限列表(无参数)
export function getPermissionList(paramInfo) {
  return request({
    url: '/permission/list',
    method: 'get',
    params: paramInfo
  })
}
// 添加角色信息
export function addRolePermission(data) {
  return request({
    url: '/role/permission/add',
    method: 'post',
    data
  })
}
// 编辑角色接口
export function editRolePermission(data) {
  return request({
    url: '/role/permission/edit',
    method: 'post',
    data
  })
}
// 删除角色接口
export function delRolePermission(paramInfo) {
  return request({
    url: '/role/permission/del',
    method: 'get',
    params: paramInfo
  })
}
// 获取权限列表
export function getPermissionListPaging(paramInfo) {
  return request({
    url: '/permission/list/paging',
    method: 'get',
    params: paramInfo
  })
}
// 新增权限接口
export function addPermissionForm(data) {
  return request({
    url: '/permission/add',
    method: 'post',
    data
  })
}
// 编辑权限接口
export function editPermissionForm(data) {
  return request({
    url: '/permission/edit',
    method: 'post',
    data
  })
}
// 删除权限接口
export function delPermissionForm(paramInfo) {
  return request({
    url: '/permission/del',
    method: 'get',
    params: paramInfo
  })
}
