import request from '@/utils/holmesRequest'

// 获取namespace列表
export function getNamespaceList(queryInfo) {
  return request({
    url: '/k8s/namespace/list',
    method: 'get',
    params: queryInfo
  })
}

// 获取服务列表
export function getServiceList(queryInfo) {
  return request({
    url: '/k8s/service/list',
    method: 'get',
    params: queryInfo
  })
}

// 获取单个类型下的所有项目
export function getSingleTypeApp(queryInfo) {
  return request({
    url: '/k8s/getSingleTypeApp',
    method: 'get',
    params: queryInfo
  })
}

// 获取镜像列表
export function getImageList(queryInfo) {
  return request({
    url: '/k8s/image/list',
    method: 'get',
    params: queryInfo
  })
}

// 创建服务
export function createK8sService(data) {
  return request({
    url: '/k8s/service/create',
    method: 'post',
    data
  })
}

// 获取k8s服务详情
export function getServiceDetail(queryInfo) {
  return request({
    url: '/k8s/service/detail',
    method: 'get',
    params: queryInfo
  })
}

// 重置服务
export function serviceRedeploy(data) {
  return request({
    url: '/k8s/service/redeploy',
    method: 'post',
    data
  })
}

// 更新服务
export function serviceUpdate(data) {
  return request({
    url: '/k8s/service/update',
    method: 'post',
    data
  })
}

// 删除服务
export function serviceDelete(data) {
  return request({
    url: '/k8s/service/delete',
    method: 'post',
    data
  })
}

// 根据类型将docker项目分类
export function getDockerProjectType(queryInfo) {
  return request({
    url: '/docker/project/type',
    method: 'get',
    params: queryInfo
  })
}

// 获取项目配置列表
export function getDockerProjectList(queryInfo) {
  return request({
    url: '/docker/project/list',
    method: 'get',
    params: queryInfo
  })
}

// 新增项目
export function addDockerProject(data) {
  return request({
    url: '/docker/project/add',
    method: 'post',
    data
  })
}

// 编辑项目
export function updateDockerProject(data) {
  return request({
    url: '/docker/project/edit',
    method: 'post',
    data
  })
}

// 获取项目配置详情
export function getDockerProjectDetail(queryInfo) {
  return request({
    url: '/docker/project/detail',
    method: 'get',
    params: queryInfo
  })
}

// 同步MQ
export function syncMq(data) {
  return request({
    url: '/k8s/sync/mq',
    method: 'post',
    data
  })
}

// 清空redis缓存
export function flushRedis(data) {
  return request({
    url: '/k8s/redis/flush',
    method: 'post',
    data
  })
}

// 根据角色id获取对应的namespace
export function getNsByRoleId(queryInfo) {
  return request({
    url: '/k8s/role/namespace',
    method: 'get',
    params: queryInfo
  })
}

// 老同步数据库接口
export function dbsync(data) {
  return request({
    url: '/dbsync/old',
    method: 'post',
    data
  })
}

// jenkins构建控制台信息获取
export function dbsyncQuery(queryInfo) {
  return request({
    url: '/dbsync/query',
    method: 'get',
    params: queryInfo
  })
}
