const state = {
  userId: '123',
  username: '',
  menuList: [],
  roleIds: [],
  permissionCodeList: []
}

const mutations = {
  SET_USER: (state, userInfo) => {
    state.userId = userInfo.id
    state.username = userInfo.username
    state.menuList = userInfo.menuList
    state.roleIds = userInfo.roleIds
    state.permissionCodeList = userInfo.permissionCodeList
  },
  RESET_USER: state => {
    state.userId = ''
    state.username = ''
    state.menuList = []
    state.roleIds = []
    state.permissionCodeList = []
  }
}
const getters = {
  UserId: state => {
    return state.userId
  }
}
const actions = {
  userMsg(context, userInfo) {
    console.log('用户信息', userInfo)
    context.commit('SET_USER', userInfo)
  }
}

export default {
  namespaced: true,
  state,
  getters,
  mutations,
  actions
}
