import request from '@/utils/holmesRequest'

export function getNavigateIndex(queryInfo) {
  return request({
    url: '/navigate/index',
    method: 'get',
    params: queryInfo
  })
}

// 获取导航列表
export function getNavigateList(queryInfo) {
  return request({
    url: '/navigate/list',
    method: 'get',
    params: queryInfo
  })
}

// 获取模块列表
export function getModuleList(queryInfo) {
  return request({
    url: '/navigate/modules',
    method: 'get',
    params: queryInfo
  })
}

// 新增导航
export function addNavigate(data) {
  return request({
    url: '/navigate/add',
    method: 'post',
    data
  })
}

// 更新导航
export function updateNavigate(data) {
  return request({
    url: '/navigate/update',
    method: 'post',
    data
  })
}

// 删除导航
export function deleteNavigate(data) {
  return request({
    url: '/navigate/delete',
    method: 'post',
    data
  })
}
