import Vue from 'vue'
// import store from '../store/store'
import NProgress from 'nprogress' // Progress 进度条
import 'nprogress/nprogress.css' // Progress 进度条样式
import Router from 'vue-router'
import Login from '../views/login/Login'
import Main from '../views/Main'
import Home from '../views/layout/Home'
import XyqbGenLoanData from '../views/xyqb/GenLoanData'
import XyqbGetLoanData from '../views/xyqb/GetLoanData'
import VccGetData from '../views/vcc/GetData'
import VccGenData from '../views/vcc/GenData'
import VccCheckData from '../views/vcc/CheckData'
import Mock from '../views/mock/Mock'
import kdspDecrypt from '../views/effect/KdspDecrypt'
import JenkinsBuildInfo from '../views/effect/JenkinsBuildInfo'
import LoginWhiteList from '../views/effect/LoginWhiteList'
// 2021-040-09新添加
import ProjectList from '../views/auto/ProjectList'
import ModelList from '../views/auto/ModelList'
import InterfaceList from '../views/auto/InterfaceList'
import JiraNotify from '../views/jira/Notify'
import RiskControl from '../views/vcc/RiskControl'
import ClearCache from '../views/effect/ClearCache'
import ClearData from '../views/effect/ClearData'
import AddInterface from '../views/auto/AddInterface'
import CaseList from '../views/auto/CaseList'
import AddCase from '../views/auto/AddCase'
import SceneList from '../views/auto/SceneList'
import EditScene from '../views/auto/EditScene'
import RepayCallback from '../views/vcc/RepayCallback'
// 添加报告页面
import ReportList from '../views/auto/ReportList'
import ReportDetail from '../views/auto/ReportDetail'
// 添加同步数据库功能
import SynDatabase from '../views/effect/SynDatabase'
// 添加用户全权限管理功能
import user from '../views/user/user'
import role from '../views/user/role'
import permission from '../views/user/permission'
// 添加发送短信功能（2021-08-16）
import sendMessage from '../views/effect/SendMessage'

const originalPush = Router.prototype.push
Router.prototype.push = function push(location) {
  return originalPush.call(this, location).catch(err => err)
}

Vue.use(Router)
const router = new Router({
  mode: 'history',
  routes: [
    {
      path: '/',
      redirect: '/login'
    },
    {
      path: '/login',
      name: '登录页',
      component: Login
    },
    {
      path: '/home',
      redirect: '/main',
      component: Home,
      children: [
        {
          path: '/main',
          name: '主页',
          component: Main
        },
        {
          path: '/xyqb/gen',
          name: '造数据',
          component: XyqbGenLoanData
        },
        {
          path: '/xyqb/get',
          name: '捞数据',
          component: XyqbGetLoanData
        },
        {
          path: '/vcc/get',
          name: 'VCC捞数据',
          component: VccGetData
        },
        {
          path: '/vcc/gen',
          name: '造数据',
          component: VccGenData
        },
        {
          path: '/vcc/check',
          name: '查数据',
          component: VccCheckData
        },
        {
          path: '/mock/list',
          name: '工具',
          component: Mock
        },
        {
          path: '/effect/decrypt',
          name: 'kdsp解密',
          component: kdspDecrypt
        },
        {
          path: '/effect/build',
          name: '构建记录',
          component: JenkinsBuildInfo
        },
        {
          path: '/effect/whitelist',
          name: '登录白名单',
          component: LoginWhiteList
        },
        // 2021-4-08新添加项目管理页面
        {
          path: '/auto/project',
          name: ProjectList,
          component: ProjectList
        },
        {
          path: '/auto/module',
          name: ModelList,
          component: ModelList
        },
        {
          path: '/auto/interface',
          name: InterfaceList,
          component: InterfaceList
        },
        {
          path: '/auto/AddInterface',
          name: AddInterface,
          component: AddInterface
        },
        {
          path: '/auto/testcase',
          name: CaseList,
          component: CaseList
        },
        {
          path: '/auto/AddCase',
          name: AddCase,
          component: AddCase
        },
        {
          path: '/auto/scene',
          name: SceneList,
          component: SceneList
        },
        // 编辑场景
        {
          path: '/auto/EditScene',
          name: EditScene,
          component: EditScene
        },
        {
          path: '/qa/process',
          component: JiraNotify
        },
        {
          path: '/vcc/risk',
          component: RiskControl
        },
        {
          path: '/effect/clearcache',
          component: ClearCache
        },
        {
          path: '/effect/cleardata',
          component: ClearData
        },
        {
          path: '/vcc/repaycallback',
          component: RepayCallback
        },
        // 添加报告
        {
          path: '/auto/report',
          name: ReportList,
          component: ReportList
        },
        {
          path: '/auto/ReportDetail',
          name: ReportDetail,
          component: ReportDetail
        },
        // 添加同步数据库
        {
          path: '/effect/database',
          name: SynDatabase,
          component: SynDatabase
        },
        // 用户管理
        {
          path: '/user/list',
          name: user,
          component: user
        },
        // 角色管理
        {
          path: '/user/role',
          name: role,
          component: role
        },
        // 权限管理
        {
          path: '/role/permission',
          name: permission,
          component: permission
        },
        // 发送短信
        {
          path: '/effect/msg',
          name: sendMessage,
          component: sendMessage
        }
      ]
    }
  ]
})
// 判断用户是否登陆到系统
router.beforeEach(function(to, from, next) {
  NProgress.start()
  var token = window.sessionStorage.getItem('token')
  if (token !== null) {
    if (to.path === '/login') {
      next('/main')
      NProgress.done() // 结束Progress
    } else if (to.path === '/main') {
      next()
    } else {
      var menuList = window.sessionStorage.getItem('menuList')
      if (menuList.indexOf(to.path) > -1) {
        next()
      } else {
        next('/main')
        NProgress.done() // 结束Progress
      }
    }
  } else {
    if (to.path === '/login') {
      next()
    } else {
      next('/login')
      NProgress.done() // 结束Progress
    }
  }
})
router.afterEach(() => {
  NProgress.done() // 结束Progress
})

export default router
