import Vue from 'vue'
import Router from 'vue-router'
import Index from '../views/index/Index'
// import Login from '../views/login/Login'
import Main from '../views/Main'
// import Home from '../views/Home'
import Home from '../views/layout/Home'
import XyqbGenLoanData from '../views/xyqb/GenLoanData'
import XyqbGetLoanData from '../views/xyqb/GetLoanData'
import VccGetData from '../views/vcc/GetData'
import VccGenData from '../views/vcc/GenData'
import VccCheckData from '../views/vcc/CheckData'
import Mock from '../views/mock/Mock'
import kdspDecrypt from '../views/effect/KdspDecrypt'
import JenkinsBuildInfo from '../views/effect/JenkinsBuildInfo'
import LoginWhiteList from '../views/effect/LoginWhiteList'
import JiraNotify from '../views/jira/Notify'
import RiskControl from '../views/vcc/RiskControl'
import ClearCache from '../views/effect/ClearCache'

Vue.use(Router)

const router = new Router({
  mode: 'history',
  routes: [
    {
      'path': '/',
      redirect: '/index'
    },
    {
      'path': '/index',
      component: Index
    },
    // {
    //   'path': '/login',
    //   component: Login
    // },
    {
      'path': '/home',
      'redirect': '/main',
      component: Home,
      children: [
        {
          'path': '/main',
          component: Main
        },
        {
          'path': '/xyqb/genLoanData',
          component: XyqbGenLoanData
        },
        {
          'path': '/xyqb/getLoanData',
          component: XyqbGetLoanData
        },
        {
          'path': '/vcc/getData',
          component: VccGetData
        },
        {
          'path': '/vcc/genData',
          component: VccGenData
        },
        {
          'path': '/vcc/checkData',
          component: VccCheckData
        },
        {
          'path': '/mock/list',
          component: Mock
        },
        {
          'path': '/effect/kdsp/decrypt',
          component: kdspDecrypt
        },
        {
          'path': '/effect/jenkins/build',
          component: JenkinsBuildInfo
        },
        {
          'path': '/effect/whitelist',
          component: LoginWhiteList
        },
        {
          'path': '/effect/jira/notify',
          component: JiraNotify
        },
        {
          'path': '/vcc/risk',
          component: RiskControl
        },
        {
          'path': '/effect/clearcache',
          component: ClearCache
        }
      ]
    }
  ]
})

export default router
